/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetClusterOptionsRequest
extends BmcRequest {
    private String clusterOptionId;
    private String compartmentId;
    private String opcRequestId;

    @ConstructorProperties(value={"clusterOptionId", "compartmentId", "opcRequestId"})
    GetClusterOptionsRequest(String clusterOptionId, String compartmentId, String opcRequestId) {
        this.clusterOptionId = clusterOptionId;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getClusterOptionId() {
        return this.clusterOptionId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String clusterOptionId;
        private String compartmentId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetClusterOptionsRequest o) {
            this.clusterOptionId(o.getClusterOptionId());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetClusterOptionsRequest build() {
            GetClusterOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder clusterOptionId(String clusterOptionId) {
            this.clusterOptionId = clusterOptionId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetClusterOptionsRequest buildWithoutInvocationCallback() {
            return new GetClusterOptionsRequest(this.clusterOptionId, this.compartmentId, this.opcRequestId);
        }

        public String toString() {
            return "GetClusterOptionsRequest.Builder(clusterOptionId=" + this.clusterOptionId + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

