/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetClusterRequest
extends BmcRequest {
    private String clusterId;
    private String opcRequestId;

    @ConstructorProperties(value={"clusterId", "opcRequestId"})
    GetClusterRequest(String clusterId, String opcRequestId) {
        this.clusterId = clusterId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String clusterId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetClusterRequest o) {
            this.clusterId(o.getClusterId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetClusterRequest build() {
            GetClusterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetClusterRequest buildWithoutInvocationCallback() {
            return new GetClusterRequest(this.clusterId, this.opcRequestId);
        }

        public String toString() {
            return "GetClusterRequest.Builder(clusterId=" + this.clusterId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

