/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.containerengine.model.UpdateNodePoolDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateNodePoolRequest
extends BmcRequest {
    private String nodePoolId;
    private UpdateNodePoolDetails updateNodePoolDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"nodePoolId", "updateNodePoolDetails", "ifMatch", "opcRequestId"})
    UpdateNodePoolRequest(String nodePoolId, UpdateNodePoolDetails updateNodePoolDetails, String ifMatch, String opcRequestId) {
        this.nodePoolId = nodePoolId;
        this.updateNodePoolDetails = updateNodePoolDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNodePoolId() {
        return this.nodePoolId;
    }

    public UpdateNodePoolDetails getUpdateNodePoolDetails() {
        return this.updateNodePoolDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String nodePoolId;
        private UpdateNodePoolDetails updateNodePoolDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateNodePoolRequest o) {
            this.nodePoolId(o.getNodePoolId());
            this.updateNodePoolDetails(o.getUpdateNodePoolDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateNodePoolRequest build() {
            UpdateNodePoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder nodePoolId(String nodePoolId) {
            this.nodePoolId = nodePoolId;
            return this;
        }

        public Builder updateNodePoolDetails(UpdateNodePoolDetails updateNodePoolDetails) {
            this.updateNodePoolDetails = updateNodePoolDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateNodePoolRequest buildWithoutInvocationCallback() {
            return new UpdateNodePoolRequest(this.nodePoolId, this.updateNodePoolDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateNodePoolRequest.Builder(nodePoolId=" + this.nodePoolId + ", updateNodePoolDetails=" + this.updateNodePoolDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

