/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.NodePoolOptions;
import java.beans.ConstructorProperties;

public class GetNodePoolOptionsResponse {
    private String opcRequestId;
    private NodePoolOptions nodePoolOptions;

    @ConstructorProperties(value={"opcRequestId", "nodePoolOptions"})
    GetNodePoolOptionsResponse(String opcRequestId, NodePoolOptions nodePoolOptions) {
        this.opcRequestId = opcRequestId;
        this.nodePoolOptions = nodePoolOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public NodePoolOptions getNodePoolOptions() {
        return this.nodePoolOptions;
    }

    public static class Builder {
        private String opcRequestId;
        private NodePoolOptions nodePoolOptions;

        public Builder copy(GetNodePoolOptionsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.nodePoolOptions(o.getNodePoolOptions());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder nodePoolOptions(NodePoolOptions nodePoolOptions) {
            this.nodePoolOptions = nodePoolOptions;
            return this;
        }

        public GetNodePoolOptionsResponse build() {
            return new GetNodePoolOptionsResponse(this.opcRequestId, this.nodePoolOptions);
        }

        public String toString() {
            return "GetNodePoolOptionsResponse.Builder(opcRequestId=" + this.opcRequestId + ", nodePoolOptions=" + this.nodePoolOptions + ")";
        }
    }
}

