/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.NodePool;
import java.beans.ConstructorProperties;

public class GetNodePoolResponse {
    private String etag;
    private String opcRequestId;
    private NodePool nodePool;

    @ConstructorProperties(value={"etag", "opcRequestId", "nodePool"})
    GetNodePoolResponse(String etag, String opcRequestId, NodePool nodePool) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.nodePool = nodePool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public NodePool getNodePool() {
        return this.nodePool;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private NodePool nodePool;

        public Builder copy(GetNodePoolResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.nodePool(o.getNodePool());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder nodePool(NodePool nodePool) {
            this.nodePool = nodePool;
            return this;
        }

        public GetNodePoolResponse build() {
            return new GetNodePoolResponse(this.etag, this.opcRequestId, this.nodePool);
        }

        public String toString() {
            return "GetNodePoolResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", nodePool=" + this.nodePool + ")";
        }
    }
}

