/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.ClusterSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListClustersResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<ClusterSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListClustersResponse(String opcNextPage, String opcRequestId, List<ClusterSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ClusterSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<ClusterSummary> items;

        public Builder copy(ListClustersResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<ClusterSummary> items) {
            this.items = items;
            return this;
        }

        public ListClustersResponse build() {
            return new ListClustersResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListClustersResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

