/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.NodePoolSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListNodePoolsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<NodePoolSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListNodePoolsResponse(String opcNextPage, String opcRequestId, List<NodePoolSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<NodePoolSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<NodePoolSummary> items;

        public Builder copy(ListNodePoolsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<NodePoolSummary> items) {
            this.items = items;
            return this;
        }

        public ListNodePoolsResponse build() {
            return new ListNodePoolsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListNodePoolsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

