/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.containerengine.ContainerEngine;
import com.oracle.bmc.containerengine.ContainerEnginePaginators;
import com.oracle.bmc.containerengine.ContainerEngineWaiters;
import com.oracle.bmc.containerengine.model.Addon;
import com.oracle.bmc.containerengine.model.AddonOptionSummary;
import com.oracle.bmc.containerengine.model.AddonSummary;
import com.oracle.bmc.containerengine.model.Cluster;
import com.oracle.bmc.containerengine.model.ClusterMigrateToNativeVcnStatus;
import com.oracle.bmc.containerengine.model.ClusterOptions;
import com.oracle.bmc.containerengine.model.ClusterSummary;
import com.oracle.bmc.containerengine.model.NodePool;
import com.oracle.bmc.containerengine.model.NodePoolOptions;
import com.oracle.bmc.containerengine.model.NodePoolSummary;
import com.oracle.bmc.containerengine.model.PodShapeSummary;
import com.oracle.bmc.containerengine.model.VirtualNode;
import com.oracle.bmc.containerengine.model.VirtualNodePool;
import com.oracle.bmc.containerengine.model.VirtualNodePoolSummary;
import com.oracle.bmc.containerengine.model.VirtualNodeSummary;
import com.oracle.bmc.containerengine.model.WorkRequest;
import com.oracle.bmc.containerengine.model.WorkRequestError;
import com.oracle.bmc.containerengine.model.WorkRequestLogEntry;
import com.oracle.bmc.containerengine.model.WorkRequestSummary;
import com.oracle.bmc.containerengine.requests.ClusterMigrateToNativeVcnRequest;
import com.oracle.bmc.containerengine.requests.CreateClusterRequest;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.requests.CreateNodePoolRequest;
import com.oracle.bmc.containerengine.requests.CreateVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteClusterRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodeRequest;
import com.oracle.bmc.containerengine.requests.DeleteVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.DisableAddonRequest;
import com.oracle.bmc.containerengine.requests.GetAddonRequest;
import com.oracle.bmc.containerengine.requests.GetClusterMigrateToNativeVcnStatusRequest;
import com.oracle.bmc.containerengine.requests.GetClusterOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetClusterRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetVirtualNodeRequest;
import com.oracle.bmc.containerengine.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.InstallAddonRequest;
import com.oracle.bmc.containerengine.requests.ListAddonOptionsRequest;
import com.oracle.bmc.containerengine.requests.ListAddonsRequest;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListPodShapesRequest;
import com.oracle.bmc.containerengine.requests.ListVirtualNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListVirtualNodesRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.requests.UpdateAddonRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterEndpointConfigRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterRequest;
import com.oracle.bmc.containerengine.requests.UpdateNodePoolRequest;
import com.oracle.bmc.containerengine.requests.UpdateVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.responses.ClusterMigrateToNativeVcnResponse;
import com.oracle.bmc.containerengine.responses.CreateClusterResponse;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import com.oracle.bmc.containerengine.responses.CreateNodePoolResponse;
import com.oracle.bmc.containerengine.responses.CreateVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteClusterResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodeResponse;
import com.oracle.bmc.containerengine.responses.DeleteVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.DisableAddonResponse;
import com.oracle.bmc.containerengine.responses.GetAddonResponse;
import com.oracle.bmc.containerengine.responses.GetClusterMigrateToNativeVcnStatusResponse;
import com.oracle.bmc.containerengine.responses.GetClusterOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetClusterResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetVirtualNodeResponse;
import com.oracle.bmc.containerengine.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.InstallAddonResponse;
import com.oracle.bmc.containerengine.responses.ListAddonOptionsResponse;
import com.oracle.bmc.containerengine.responses.ListAddonsResponse;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListPodShapesResponse;
import com.oracle.bmc.containerengine.responses.ListVirtualNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListVirtualNodesResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerengine.responses.UpdateAddonResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterEndpointConfigResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterResponse;
import com.oracle.bmc.containerengine.responses.UpdateNodePoolResponse;
import com.oracle.bmc.containerengine.responses.UpdateVirtualNodePoolResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEngineClient
extends BaseSyncClient
implements ContainerEngine {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONTAINERENGINE").serviceEndpointPrefix("containerengine").serviceEndpointTemplate("https://containerengine.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEngineClient.class);
    private final ContainerEngineWaiters waiters;
    private final ContainerEnginePaginators paginators;

    ContainerEngineClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    ContainerEngineClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ContainerEngine-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ContainerEngineWaiters(executorService, this);
        this.paginators = new ContainerEnginePaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ContainerEngineClient", (String)"createKubeconfig"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ClusterMigrateToNativeVcnResponse clusterMigrateToNativeVcn(ClusterMigrateToNativeVcnRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getClusterMigrateToNativeVcnDetails(), "clusterMigrateToNativeVcnDetails is required");
        return (ClusterMigrateToNativeVcnResponse)this.clientCall(request, ClusterMigrateToNativeVcnResponse::builder).logger(LOG, "clusterMigrateToNativeVcn").serviceDetails("ContainerEngine", "ClusterMigrateToNativeVcn", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/ClusterMigrateToNativeVcn").method(Method.POST).requestBuilder(ClusterMigrateToNativeVcnRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("migrateToNativeVcn").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ClusterMigrateToNativeVcnResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ClusterMigrateToNativeVcnResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest request) {
        Objects.requireNonNull(request.getCreateClusterDetails(), "createClusterDetails is required");
        return (CreateClusterResponse)this.clientCall(request, CreateClusterResponse::builder).logger(LOG, "createCluster").serviceDetails("ContainerEngine", "CreateCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/CreateCluster").method(Method.POST).requestBuilder(CreateClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateKubeconfigResponse createKubeconfig(CreateKubeconfigRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return (CreateKubeconfigResponse)this.clientCall(request, CreateKubeconfigResponse::builder).logger(LOG, "createKubeconfig").serviceDetails("ContainerEngine", "CreateKubeconfig", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/CreateKubeconfig").method(Method.POST).requestBuilder(CreateKubeconfigRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("kubeconfig").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, CreateKubeconfigResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", CreateKubeconfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateNodePoolResponse createNodePool(CreateNodePoolRequest request) {
        Objects.requireNonNull(request.getCreateNodePoolDetails(), "createNodePoolDetails is required");
        return (CreateNodePoolResponse)this.clientCall(request, CreateNodePoolResponse::builder).logger(LOG, "createNodePool").serviceDetails("ContainerEngine", "CreateNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/CreateNodePool").method(Method.POST).requestBuilder(CreateNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateVirtualNodePoolResponse createVirtualNodePool(CreateVirtualNodePoolRequest request) {
        Objects.requireNonNull(request.getCreateVirtualNodePoolDetails(), "createVirtualNodePoolDetails is required");
        return (CreateVirtualNodePoolResponse)this.clientCall(request, CreateVirtualNodePoolResponse::builder).logger(LOG, "createVirtualNodePool").serviceDetails("ContainerEngine", "CreateVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/CreateVirtualNodePool").method(Method.POST).requestBuilder(CreateVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateVirtualNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return (DeleteClusterResponse)this.clientCall(request, DeleteClusterResponse::builder).logger(LOG, "deleteCluster").serviceDetails("ContainerEngine", "DeleteCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/DeleteCluster").method(Method.DELETE).requestBuilder(DeleteClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteNodeResponse deleteNode(DeleteNodeRequest request) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNodeId(), (String)"nodeId must not be blank", (Object[])new Object[0]);
        return (DeleteNodeResponse)this.clientCall(request, DeleteNodeResponse::builder).logger(LOG, "deleteNode").serviceDetails("ContainerEngine", "DeleteNode", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/DeleteNode").method(Method.DELETE).requestBuilder(DeleteNodeRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendPathParam("node").appendPathParam(request.getNodeId()).appendQueryParam("isDecrementSize", (Object)request.getIsDecrementSize()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNodeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNodeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteNodePoolResponse deleteNodePool(DeleteNodePoolRequest request) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        return (DeleteNodePoolResponse)this.clientCall(request, DeleteNodePoolResponse::builder).logger(LOG, "deleteNodePool").serviceDetails("ContainerEngine", "DeleteNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/DeleteNodePool").method(Method.DELETE).requestBuilder(DeleteNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteVirtualNodePoolResponse deleteVirtualNodePool(DeleteVirtualNodePoolRequest request) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        return (DeleteVirtualNodePoolResponse)this.clientCall(request, DeleteVirtualNodePoolResponse::builder).logger(LOG, "deleteVirtualNodePool").serviceDetails("ContainerEngine", "DeleteVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/DeleteVirtualNodePool").method(Method.DELETE).requestBuilder(DeleteVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).appendQueryParam("overrideEvictionGraceDurationVnp", (Object)request.getOverrideEvictionGraceDurationVnp()).appendQueryParam("isForceDeletionAfterOverrideGraceDurationVnp", (Object)request.getIsForceDeletionAfterOverrideGraceDurationVnp()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVirtualNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (DeleteWorkRequestResponse)this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("ContainerEngine", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DisableAddonResponse disableAddon(DisableAddonRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAddonName(), (String)"addonName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getIsRemoveExistingAddOn(), "isRemoveExistingAddOn is required");
        return (DisableAddonResponse)this.clientCall(request, DisableAddonResponse::builder).logger(LOG, "disableAddon").serviceDetails("ContainerEngine", "DisableAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/DisableAddon").method(Method.DELETE).requestBuilder(DisableAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendPathParam(request.getAddonName()).appendQueryParam("isRemoveExistingAddOn", (Object)request.getIsRemoveExistingAddOn()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DisableAddonResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableAddonResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetAddonResponse getAddon(GetAddonRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAddonName(), (String)"addonName must not be blank", (Object[])new Object[0]);
        return (GetAddonResponse)this.clientCall(request, GetAddonResponse::builder).logger(LOG, "getAddon").serviceDetails("ContainerEngine", "GetAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/GetAddon").method(Method.GET).requestBuilder(GetAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendPathParam(request.getAddonName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Addon.class, GetAddonResponse.Builder::addon).handleResponseHeaderString("etag", GetAddonResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAddonResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetClusterResponse getCluster(GetClusterRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return (GetClusterResponse)this.clientCall(request, GetClusterResponse::builder).logger(LOG, "getCluster").serviceDetails("ContainerEngine", "GetCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/GetCluster").method(Method.GET).requestBuilder(GetClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Cluster.class, GetClusterResponse.Builder::cluster).handleResponseHeaderString("etag", GetClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetClusterMigrateToNativeVcnStatusResponse getClusterMigrateToNativeVcnStatus(GetClusterMigrateToNativeVcnStatusRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return (GetClusterMigrateToNativeVcnStatusResponse)this.clientCall(request, GetClusterMigrateToNativeVcnStatusResponse::builder).logger(LOG, "getClusterMigrateToNativeVcnStatus").serviceDetails("ContainerEngine", "GetClusterMigrateToNativeVcnStatus", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterMigrateToNativeVcnStatus/GetClusterMigrateToNativeVcnStatus").method(Method.GET).requestBuilder(GetClusterMigrateToNativeVcnStatusRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("migrateToNativeVcnStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterMigrateToNativeVcnStatus.class, GetClusterMigrateToNativeVcnStatusResponse.Builder::clusterMigrateToNativeVcnStatus).handleResponseHeaderString("etag", GetClusterMigrateToNativeVcnStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterMigrateToNativeVcnStatusResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetClusterOptionsResponse getClusterOptions(GetClusterOptionsRequest request) {
        Validate.notBlank((String)request.getClusterOptionId(), (String)"clusterOptionId must not be blank", (Object[])new Object[0]);
        return (GetClusterOptionsResponse)this.clientCall(request, GetClusterOptionsResponse::builder).logger(LOG, "getClusterOptions").serviceDetails("ContainerEngine", "GetClusterOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterOptions/GetClusterOptions").method(Method.GET).requestBuilder(GetClusterOptionsRequest::builder).basePath("/20180222").appendPathParam("clusterOptions").appendPathParam(request.getClusterOptionId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterOptions.class, GetClusterOptionsResponse.Builder::clusterOptions).handleResponseHeaderString("opc-request-id", GetClusterOptionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetNodePoolResponse getNodePool(GetNodePoolRequest request) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        return (GetNodePoolResponse)this.clientCall(request, GetNodePoolResponse::builder).logger(LOG, "getNodePool").serviceDetails("ContainerEngine", "GetNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/GetNodePool").method(Method.GET).requestBuilder(GetNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NodePool.class, GetNodePoolResponse.Builder::nodePool).handleResponseHeaderString("etag", GetNodePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetNodePoolOptionsResponse getNodePoolOptions(GetNodePoolOptionsRequest request) {
        Validate.notBlank((String)request.getNodePoolOptionId(), (String)"nodePoolOptionId must not be blank", (Object[])new Object[0]);
        return (GetNodePoolOptionsResponse)this.clientCall(request, GetNodePoolOptionsResponse::builder).logger(LOG, "getNodePoolOptions").serviceDetails("ContainerEngine", "GetNodePoolOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePoolOptions/GetNodePoolOptions").method(Method.GET).requestBuilder(GetNodePoolOptionsRequest::builder).basePath("/20180222").appendPathParam("nodePoolOptions").appendPathParam(request.getNodePoolOptionId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NodePoolOptions.class, GetNodePoolOptionsResponse.Builder::nodePoolOptions).handleResponseHeaderString("opc-request-id", GetNodePoolOptionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetVirtualNodeResponse getVirtualNode(GetVirtualNodeRequest request) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVirtualNodeId(), (String)"virtualNodeId must not be blank", (Object[])new Object[0]);
        return (GetVirtualNodeResponse)this.clientCall(request, GetVirtualNodeResponse::builder).logger(LOG, "getVirtualNode").serviceDetails("ContainerEngine", "GetVirtualNode", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/GetVirtualNode").method(Method.GET).requestBuilder(GetVirtualNodeRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).appendPathParam("virtualNodes").appendPathParam(request.getVirtualNodeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualNode.class, GetVirtualNodeResponse.Builder::virtualNode).handleResponseHeaderString("etag", GetVirtualNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualNodeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetVirtualNodePoolResponse getVirtualNodePool(GetVirtualNodePoolRequest request) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        return (GetVirtualNodePoolResponse)this.clientCall(request, GetVirtualNodePoolResponse::builder).logger(LOG, "getVirtualNodePool").serviceDetails("ContainerEngine", "GetVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/GetVirtualNodePool").method(Method.GET).requestBuilder(GetVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualNodePool.class, GetVirtualNodePoolResponse.Builder::virtualNodePool).handleResponseHeaderString("etag", GetVirtualNodePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ContainerEngine", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public InstallAddonResponse installAddon(InstallAddonRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallAddonDetails(), "installAddonDetails is required");
        return (InstallAddonResponse)this.clientCall(request, InstallAddonResponse::builder).logger(LOG, "installAddon").serviceDetails("ContainerEngine", "InstallAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/InstallAddon").method(Method.POST).requestBuilder(InstallAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", InstallAddonResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallAddonResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAddonOptionsResponse listAddonOptions(ListAddonOptionsRequest request) {
        Objects.requireNonNull(request.getKubernetesVersion(), "kubernetesVersion is required");
        return (ListAddonOptionsResponse)this.clientCall(request, ListAddonOptionsResponse::builder).logger(LOG, "listAddonOptions").serviceDetails("ContainerEngine", "ListAddonOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/AddonOptionSummary/ListAddonOptions").method(Method.GET).requestBuilder(ListAddonOptionsRequest::builder).basePath("/20180222").appendPathParam("addonOptions").appendQueryParam("kubernetesVersion", (Object)request.getKubernetesVersion()).appendQueryParam("addonName", (Object)request.getAddonName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AddonOptionSummary.class, ListAddonOptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAddonOptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAddonOptionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAddonsResponse listAddons(ListAddonsRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return (ListAddonsResponse)this.clientCall(request, ListAddonsResponse::builder).logger(LOG, "listAddons").serviceDetails("ContainerEngine", "ListAddons", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/ListAddons").method(Method.GET).requestBuilder(ListAddonsRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AddonSummary.class, ListAddonsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAddonsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAddonsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListClustersResponse listClusters(ListClustersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListClustersResponse)this.clientCall(request, ListClustersResponse::builder).logger(LOG, "listClusters").serviceDetails("ContainerEngine", "ListClusters", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterSummary/ListClusters").method(Method.GET).requestBuilder(ListClustersRequest::builder).basePath("/20180222").appendPathParam("clusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ClusterSummary.class, ListClustersResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListClustersResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListNodePoolsResponse listNodePools(ListNodePoolsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNodePoolsResponse)this.clientCall(request, ListNodePoolsResponse::builder).logger(LOG, "listNodePools").serviceDetails("ContainerEngine", "ListNodePools", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePoolSummary/ListNodePools").method(Method.GET).requestBuilder(ListNodePoolsRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(NodePoolSummary.class, ListNodePoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNodePoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNodePoolsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListPodShapesResponse listPodShapes(ListPodShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPodShapesResponse)this.clientCall(request, ListPodShapesResponse::builder).logger(LOG, "listPodShapes").serviceDetails("ContainerEngine", "ListPodShapes", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/PodShapeSummary/ListPodShapes").method(Method.GET).requestBuilder(ListPodShapesRequest::builder).basePath("/20180222").appendPathParam("podShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PodShapeSummary.class, ListPodShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPodShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPodShapesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListVirtualNodePoolsResponse listVirtualNodePools(ListVirtualNodePoolsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVirtualNodePoolsResponse)this.clientCall(request, ListVirtualNodePoolsResponse::builder).logger(LOG, "listVirtualNodePools").serviceDetails("ContainerEngine", "ListVirtualNodePools", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePoolSummary/ListVirtualNodePools").method(Method.GET).requestBuilder(ListVirtualNodePoolsRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(VirtualNodePoolSummary.class, ListVirtualNodePoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVirtualNodePoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVirtualNodePoolsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListVirtualNodesResponse listVirtualNodes(ListVirtualNodesRequest request) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        return (ListVirtualNodesResponse)this.clientCall(request, ListVirtualNodesResponse::builder).logger(LOG, "listVirtualNodes").serviceDetails("ContainerEngine", "ListVirtualNodes", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/ListVirtualNodes").method(Method.GET).requestBuilder(ListVirtualNodesRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).appendPathParam("virtualNodes").appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(VirtualNodeSummary.class, ListVirtualNodesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVirtualNodesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVirtualNodesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ContainerEngine", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ContainerEngine", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ContainerEngine", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("resourceType", (BmcEnum)request.getResourceType()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateAddonResponse updateAddon(UpdateAddonRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAddonName(), (String)"addonName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAddonDetails(), "updateAddonDetails is required");
        return (UpdateAddonResponse)this.clientCall(request, UpdateAddonResponse::builder).logger(LOG, "updateAddon").serviceDetails("ContainerEngine", "UpdateAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateAddon").method(Method.PUT).requestBuilder(UpdateAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendPathParam(request.getAddonName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAddonResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAddonResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterDetails(), "updateClusterDetails is required");
        return (UpdateClusterResponse)this.clientCall(request, UpdateClusterResponse::builder).logger(LOG, "updateCluster").serviceDetails("ContainerEngine", "UpdateCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateCluster").method(Method.PUT).requestBuilder(UpdateClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateClusterEndpointConfigResponse updateClusterEndpointConfig(UpdateClusterEndpointConfigRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterEndpointConfigDetails(), "updateClusterEndpointConfigDetails is required");
        return (UpdateClusterEndpointConfigResponse)this.clientCall(request, UpdateClusterEndpointConfigResponse::builder).logger(LOG, "updateClusterEndpointConfig").serviceDetails("ContainerEngine", "UpdateClusterEndpointConfig", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateClusterEndpointConfig").method(Method.POST).requestBuilder(UpdateClusterEndpointConfigRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("updateEndpointConfig").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateClusterEndpointConfigResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateClusterEndpointConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateNodePoolResponse updateNodePool(UpdateNodePoolRequest request) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNodePoolDetails(), "updateNodePoolDetails is required");
        return (UpdateNodePoolResponse)this.clientCall(request, UpdateNodePoolResponse::builder).logger(LOG, "updateNodePool").serviceDetails("ContainerEngine", "UpdateNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/UpdateNodePool").method(Method.PUT).requestBuilder(UpdateNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateVirtualNodePoolResponse updateVirtualNodePool(UpdateVirtualNodePoolRequest request) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualNodePoolDetails(), "updateVirtualNodePoolDetails is required");
        return (UpdateVirtualNodePoolResponse)this.clientCall(request, UpdateVirtualNodePoolResponse::builder).logger(LOG, "updateVirtualNodePool").serviceDetails("ContainerEngine", "UpdateVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/UpdateVirtualNodePool").method(Method.PUT).requestBuilder(UpdateVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualNodePoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ContainerEngineWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ContainerEnginePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ContainerEngineClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ContainerEngineClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerEngineClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ContainerEngineClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerEngineClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ContainerEngineClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerEngineClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ContainerEngineClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerEngineClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ContainerEngineClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerEngineClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ContainerEngineClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerEngineClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ContainerEngineClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerEngineClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ContainerEngineClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ContainerEngineClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ContainerEngineClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ContainerEngineClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

