/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.oracle.bmc.containerengine.ContainerEngine;
import com.oracle.bmc.containerengine.model.AddonLifecycleState;
import com.oracle.bmc.containerengine.model.ClusterLifecycleState;
import com.oracle.bmc.containerengine.model.NodePoolLifecycleState;
import com.oracle.bmc.containerengine.model.VirtualNodeLifecycleState;
import com.oracle.bmc.containerengine.model.VirtualNodePoolLifecycleState;
import com.oracle.bmc.containerengine.requests.GetAddonRequest;
import com.oracle.bmc.containerengine.requests.GetClusterRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetVirtualNodeRequest;
import com.oracle.bmc.containerengine.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerengine.responses.GetAddonResponse;
import com.oracle.bmc.containerengine.responses.GetClusterResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetVirtualNodeResponse;
import com.oracle.bmc.containerengine.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ContainerEngineWaiters {
    private final ExecutorService executorService;
    private final ContainerEngine client;

    public ContainerEngineWaiters(ExecutorService executorService, ContainerEngine client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAddonRequest, GetAddonResponse> forAddon(GetAddonRequest request, AddonLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAddon(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAddonRequest, GetAddonResponse> forAddon(GetAddonRequest request, AddonLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAddon(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAddonRequest, GetAddonResponse> forAddon(GetAddonRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AddonLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAddon(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAddonRequest, GetAddonResponse> forAddon(BmcGenericWaiter waiter, GetAddonRequest request, AddonLifecycleState ... targetStates) {
        final HashSet<AddonLifecycleState> targetStatesSet = new HashSet<AddonLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAddonRequest, GetAddonResponse>(){

            @Override
            public GetAddonResponse apply(GetAddonRequest request) {
                return ContainerEngineWaiters.this.client.getAddon(request);
            }
        }, (Predicate)new Predicate<GetAddonResponse>(){

            @Override
            public boolean test(GetAddonResponse response) {
                return targetStatesSet.contains((Object)response.getAddon().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AddonLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetClusterRequest, GetClusterResponse> forCluster(GetClusterRequest request, ClusterLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetClusterRequest, GetClusterResponse> forCluster(GetClusterRequest request, ClusterLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetClusterRequest, GetClusterResponse> forCluster(GetClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ClusterLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetClusterRequest, GetClusterResponse> forCluster(BmcGenericWaiter waiter, GetClusterRequest request, ClusterLifecycleState ... targetStates) {
        final HashSet<ClusterLifecycleState> targetStatesSet = new HashSet<ClusterLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetClusterRequest, GetClusterResponse>(){

            @Override
            public GetClusterResponse apply(GetClusterRequest request) {
                return ContainerEngineWaiters.this.client.getCluster(request);
            }
        }, (Predicate)new Predicate<GetClusterResponse>(){

            @Override
            public boolean test(GetClusterResponse response) {
                return targetStatesSet.contains((Object)response.getCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ClusterLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetNodePoolRequest, GetNodePoolResponse> forNodePool(GetNodePoolRequest request, NodePoolLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNodePool(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNodePoolRequest, GetNodePoolResponse> forNodePool(GetNodePoolRequest request, NodePoolLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNodePool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNodePoolRequest, GetNodePoolResponse> forNodePool(GetNodePoolRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NodePoolLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNodePool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNodePoolRequest, GetNodePoolResponse> forNodePool(BmcGenericWaiter waiter, GetNodePoolRequest request, NodePoolLifecycleState ... targetStates) {
        final HashSet<NodePoolLifecycleState> targetStatesSet = new HashSet<NodePoolLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNodePoolRequest, GetNodePoolResponse>(){

            @Override
            public GetNodePoolResponse apply(GetNodePoolRequest request) {
                return ContainerEngineWaiters.this.client.getNodePool(request);
            }
        }, (Predicate)new Predicate<GetNodePoolResponse>(){

            @Override
            public boolean test(GetNodePoolResponse response) {
                return targetStatesSet.contains((Object)response.getNodePool().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NodePoolLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVirtualNodeRequest, GetVirtualNodeResponse> forVirtualNode(GetVirtualNodeRequest request, VirtualNodeLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualNode(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVirtualNodeRequest, GetVirtualNodeResponse> forVirtualNode(GetVirtualNodeRequest request, VirtualNodeLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVirtualNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVirtualNodeRequest, GetVirtualNodeResponse> forVirtualNode(GetVirtualNodeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VirtualNodeLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVirtualNodeRequest, GetVirtualNodeResponse> forVirtualNode(BmcGenericWaiter waiter, GetVirtualNodeRequest request, VirtualNodeLifecycleState ... targetStates) {
        final HashSet<VirtualNodeLifecycleState> targetStatesSet = new HashSet<VirtualNodeLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVirtualNodeRequest, GetVirtualNodeResponse>(){

            @Override
            public GetVirtualNodeResponse apply(GetVirtualNodeRequest request) {
                return ContainerEngineWaiters.this.client.getVirtualNode(request);
            }
        }, (Predicate)new Predicate<GetVirtualNodeResponse>(){

            @Override
            public boolean test(GetVirtualNodeResponse response) {
                return targetStatesSet.contains((Object)response.getVirtualNode().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VirtualNodeLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVirtualNodePoolRequest, GetVirtualNodePoolResponse> forVirtualNodePool(GetVirtualNodePoolRequest request, VirtualNodePoolLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualNodePool(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVirtualNodePoolRequest, GetVirtualNodePoolResponse> forVirtualNodePool(GetVirtualNodePoolRequest request, VirtualNodePoolLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVirtualNodePool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVirtualNodePoolRequest, GetVirtualNodePoolResponse> forVirtualNodePool(GetVirtualNodePoolRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VirtualNodePoolLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualNodePool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVirtualNodePoolRequest, GetVirtualNodePoolResponse> forVirtualNodePool(BmcGenericWaiter waiter, GetVirtualNodePoolRequest request, VirtualNodePoolLifecycleState ... targetStates) {
        final HashSet<VirtualNodePoolLifecycleState> targetStatesSet = new HashSet<VirtualNodePoolLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVirtualNodePoolRequest, GetVirtualNodePoolResponse>(){

            @Override
            public GetVirtualNodePoolResponse apply(GetVirtualNodePoolRequest request) {
                return ContainerEngineWaiters.this.client.getVirtualNodePool(request);
            }
        }, (Predicate)new Predicate<GetVirtualNodePoolResponse>(){

            @Override
            public boolean test(GetVirtualNodePoolResponse response) {
                return targetStatesSet.contains((Object)response.getVirtualNodePool().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VirtualNodePoolLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ContainerEngineWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

