/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.ClusterCreateOptions;
import com.oracle.bmc.containerengine.model.ClusterEndpointConfig;
import com.oracle.bmc.containerengine.model.ClusterEndpoints;
import com.oracle.bmc.containerengine.model.ClusterLifecycleState;
import com.oracle.bmc.containerengine.model.ClusterMetadata;
import com.oracle.bmc.containerengine.model.ClusterPodNetworkOptionDetails;
import com.oracle.bmc.containerengine.model.ClusterType;
import com.oracle.bmc.containerengine.model.ImagePolicyConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Cluster
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="endpointConfig")
    private final ClusterEndpointConfig endpointConfig;
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="kubernetesVersion")
    private final String kubernetesVersion;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="options")
    private final ClusterCreateOptions options;
    @JsonProperty(value="metadata")
    private final ClusterMetadata metadata;
    @JsonProperty(value="lifecycleState")
    private final ClusterLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="endpoints")
    private final ClusterEndpoints endpoints;
    @JsonProperty(value="availableKubernetesUpgrades")
    private final List<String> availableKubernetesUpgrades;
    @JsonProperty(value="imagePolicyConfig")
    private final ImagePolicyConfig imagePolicyConfig;
    @JsonProperty(value="clusterPodNetworkOptions")
    private final List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions;
    @JsonProperty(value="type")
    private final ClusterType type;
    @JsonProperty(value="openIdConnectDiscoveryEndpoint")
    private final String openIdConnectDiscoveryEndpoint;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "compartmentId", "endpointConfig", "vcnId", "kubernetesVersion", "kmsKeyId", "freeformTags", "definedTags", "systemTags", "options", "metadata", "lifecycleState", "lifecycleDetails", "endpoints", "availableKubernetesUpgrades", "imagePolicyConfig", "clusterPodNetworkOptions", "type", "openIdConnectDiscoveryEndpoint"})
    public Cluster(String id, String name, String compartmentId, ClusterEndpointConfig endpointConfig, String vcnId, String kubernetesVersion, String kmsKeyId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, ClusterCreateOptions options, ClusterMetadata metadata, ClusterLifecycleState lifecycleState, String lifecycleDetails, ClusterEndpoints endpoints, List<String> availableKubernetesUpgrades, ImagePolicyConfig imagePolicyConfig, List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions, ClusterType type, String openIdConnectDiscoveryEndpoint) {
        this.id = id;
        this.name = name;
        this.compartmentId = compartmentId;
        this.endpointConfig = endpointConfig;
        this.vcnId = vcnId;
        this.kubernetesVersion = kubernetesVersion;
        this.kmsKeyId = kmsKeyId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.options = options;
        this.metadata = metadata;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.endpoints = endpoints;
        this.availableKubernetesUpgrades = availableKubernetesUpgrades;
        this.imagePolicyConfig = imagePolicyConfig;
        this.clusterPodNetworkOptions = clusterPodNetworkOptions;
        this.type = type;
        this.openIdConnectDiscoveryEndpoint = openIdConnectDiscoveryEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ClusterEndpointConfig getEndpointConfig() {
        return this.endpointConfig;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getKubernetesVersion() {
        return this.kubernetesVersion;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public ClusterCreateOptions getOptions() {
        return this.options;
    }

    public ClusterMetadata getMetadata() {
        return this.metadata;
    }

    public ClusterLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public ClusterEndpoints getEndpoints() {
        return this.endpoints;
    }

    public List<String> getAvailableKubernetesUpgrades() {
        return this.availableKubernetesUpgrades;
    }

    public ImagePolicyConfig getImagePolicyConfig() {
        return this.imagePolicyConfig;
    }

    public List<ClusterPodNetworkOptionDetails> getClusterPodNetworkOptions() {
        return this.clusterPodNetworkOptions;
    }

    public ClusterType getType() {
        return this.type;
    }

    public String getOpenIdConnectDiscoveryEndpoint() {
        return this.openIdConnectDiscoveryEndpoint;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cluster(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", endpointConfig=").append(String.valueOf((Object)this.endpointConfig));
        sb.append(", vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", kubernetesVersion=").append(String.valueOf(this.kubernetesVersion));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", options=").append(String.valueOf((Object)this.options));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", endpoints=").append(String.valueOf((Object)this.endpoints));
        sb.append(", availableKubernetesUpgrades=").append(String.valueOf(this.availableKubernetesUpgrades));
        sb.append(", imagePolicyConfig=").append(String.valueOf((Object)this.imagePolicyConfig));
        sb.append(", clusterPodNetworkOptions=").append(String.valueOf(this.clusterPodNetworkOptions));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", openIdConnectDiscoveryEndpoint=").append(String.valueOf(this.openIdConnectDiscoveryEndpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.endpointConfig, (Object)other.endpointConfig) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.kubernetesVersion, other.kubernetesVersion) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals((Object)this.options, (Object)other.options) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.endpoints, (Object)other.endpoints) && Objects.equals(this.availableKubernetesUpgrades, other.availableKubernetesUpgrades) && Objects.equals((Object)this.imagePolicyConfig, (Object)other.imagePolicyConfig) && Objects.equals(this.clusterPodNetworkOptions, other.clusterPodNetworkOptions) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.openIdConnectDiscoveryEndpoint, other.openIdConnectDiscoveryEndpoint) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.endpointConfig == null ? 43 : this.endpointConfig.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.kubernetesVersion == null ? 43 : this.kubernetesVersion.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.options == null ? 43 : this.options.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.endpoints == null ? 43 : this.endpoints.hashCode());
        result = result * 59 + (this.availableKubernetesUpgrades == null ? 43 : this.availableKubernetesUpgrades.hashCode());
        result = result * 59 + (this.imagePolicyConfig == null ? 43 : this.imagePolicyConfig.hashCode());
        result = result * 59 + (this.clusterPodNetworkOptions == null ? 43 : this.clusterPodNetworkOptions.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.openIdConnectDiscoveryEndpoint == null ? 43 : this.openIdConnectDiscoveryEndpoint.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="endpointConfig")
        private ClusterEndpointConfig endpointConfig;
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="kubernetesVersion")
        private String kubernetesVersion;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="options")
        private ClusterCreateOptions options;
        @JsonProperty(value="metadata")
        private ClusterMetadata metadata;
        @JsonProperty(value="lifecycleState")
        private ClusterLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="endpoints")
        private ClusterEndpoints endpoints;
        @JsonProperty(value="availableKubernetesUpgrades")
        private List<String> availableKubernetesUpgrades;
        @JsonProperty(value="imagePolicyConfig")
        private ImagePolicyConfig imagePolicyConfig;
        @JsonProperty(value="clusterPodNetworkOptions")
        private List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions;
        @JsonProperty(value="type")
        private ClusterType type;
        @JsonProperty(value="openIdConnectDiscoveryEndpoint")
        private String openIdConnectDiscoveryEndpoint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder endpointConfig(ClusterEndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            this.__explicitlySet__.add("endpointConfig");
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            this.__explicitlySet__.add("kubernetesVersion");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder options(ClusterCreateOptions options) {
            this.options = options;
            this.__explicitlySet__.add("options");
            return this;
        }

        public Builder metadata(ClusterMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder lifecycleState(ClusterLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder endpoints(ClusterEndpoints endpoints) {
            this.endpoints = endpoints;
            this.__explicitlySet__.add("endpoints");
            return this;
        }

        public Builder availableKubernetesUpgrades(List<String> availableKubernetesUpgrades) {
            this.availableKubernetesUpgrades = availableKubernetesUpgrades;
            this.__explicitlySet__.add("availableKubernetesUpgrades");
            return this;
        }

        public Builder imagePolicyConfig(ImagePolicyConfig imagePolicyConfig) {
            this.imagePolicyConfig = imagePolicyConfig;
            this.__explicitlySet__.add("imagePolicyConfig");
            return this;
        }

        public Builder clusterPodNetworkOptions(List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions) {
            this.clusterPodNetworkOptions = clusterPodNetworkOptions;
            this.__explicitlySet__.add("clusterPodNetworkOptions");
            return this;
        }

        public Builder type(ClusterType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder openIdConnectDiscoveryEndpoint(String openIdConnectDiscoveryEndpoint) {
            this.openIdConnectDiscoveryEndpoint = openIdConnectDiscoveryEndpoint;
            this.__explicitlySet__.add("openIdConnectDiscoveryEndpoint");
            return this;
        }

        public Cluster build() {
            Cluster model = new Cluster(this.id, this.name, this.compartmentId, this.endpointConfig, this.vcnId, this.kubernetesVersion, this.kmsKeyId, this.freeformTags, this.definedTags, this.systemTags, this.options, this.metadata, this.lifecycleState, this.lifecycleDetails, this.endpoints, this.availableKubernetesUpgrades, this.imagePolicyConfig, this.clusterPodNetworkOptions, this.type, this.openIdConnectDiscoveryEndpoint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Cluster model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("endpointConfig")) {
                this.endpointConfig(model.getEndpointConfig());
            }
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("kubernetesVersion")) {
                this.kubernetesVersion(model.getKubernetesVersion());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("options")) {
                this.options(model.getOptions());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("endpoints")) {
                this.endpoints(model.getEndpoints());
            }
            if (model.wasPropertyExplicitlySet("availableKubernetesUpgrades")) {
                this.availableKubernetesUpgrades(model.getAvailableKubernetesUpgrades());
            }
            if (model.wasPropertyExplicitlySet("imagePolicyConfig")) {
                this.imagePolicyConfig(model.getImagePolicyConfig());
            }
            if (model.wasPropertyExplicitlySet("clusterPodNetworkOptions")) {
                this.clusterPodNetworkOptions(model.getClusterPodNetworkOptions());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("openIdConnectDiscoveryEndpoint")) {
                this.openIdConnectDiscoveryEndpoint(model.getOpenIdConnectDiscoveryEndpoint());
            }
            return this;
        }
    }
}

