/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.AddOnOptions;
import com.oracle.bmc.containerengine.model.AdmissionControllerOptions;
import com.oracle.bmc.containerengine.model.KubernetesNetworkConfig;
import com.oracle.bmc.containerengine.model.OpenIdConnectDiscovery;
import com.oracle.bmc.containerengine.model.OpenIdConnectTokenAuthenticationConfig;
import com.oracle.bmc.containerengine.model.PersistentVolumeConfigDetails;
import com.oracle.bmc.containerengine.model.ServiceLbConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClusterCreateOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="serviceLbSubnetIds")
    private final List<String> serviceLbSubnetIds;
    @JsonProperty(value="kubernetesNetworkConfig")
    private final KubernetesNetworkConfig kubernetesNetworkConfig;
    @JsonProperty(value="addOns")
    private final AddOnOptions addOns;
    @JsonProperty(value="admissionControllerOptions")
    private final AdmissionControllerOptions admissionControllerOptions;
    @JsonProperty(value="persistentVolumeConfig")
    private final PersistentVolumeConfigDetails persistentVolumeConfig;
    @JsonProperty(value="serviceLbConfig")
    private final ServiceLbConfigDetails serviceLbConfig;
    @JsonProperty(value="openIdConnectTokenAuthenticationConfig")
    private final OpenIdConnectTokenAuthenticationConfig openIdConnectTokenAuthenticationConfig;
    @JsonProperty(value="openIdConnectDiscovery")
    private final OpenIdConnectDiscovery openIdConnectDiscovery;

    @Deprecated
    @ConstructorProperties(value={"serviceLbSubnetIds", "kubernetesNetworkConfig", "addOns", "admissionControllerOptions", "persistentVolumeConfig", "serviceLbConfig", "openIdConnectTokenAuthenticationConfig", "openIdConnectDiscovery"})
    public ClusterCreateOptions(List<String> serviceLbSubnetIds, KubernetesNetworkConfig kubernetesNetworkConfig, AddOnOptions addOns, AdmissionControllerOptions admissionControllerOptions, PersistentVolumeConfigDetails persistentVolumeConfig, ServiceLbConfigDetails serviceLbConfig, OpenIdConnectTokenAuthenticationConfig openIdConnectTokenAuthenticationConfig, OpenIdConnectDiscovery openIdConnectDiscovery) {
        this.serviceLbSubnetIds = serviceLbSubnetIds;
        this.kubernetesNetworkConfig = kubernetesNetworkConfig;
        this.addOns = addOns;
        this.admissionControllerOptions = admissionControllerOptions;
        this.persistentVolumeConfig = persistentVolumeConfig;
        this.serviceLbConfig = serviceLbConfig;
        this.openIdConnectTokenAuthenticationConfig = openIdConnectTokenAuthenticationConfig;
        this.openIdConnectDiscovery = openIdConnectDiscovery;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getServiceLbSubnetIds() {
        return this.serviceLbSubnetIds;
    }

    public KubernetesNetworkConfig getKubernetesNetworkConfig() {
        return this.kubernetesNetworkConfig;
    }

    public AddOnOptions getAddOns() {
        return this.addOns;
    }

    public AdmissionControllerOptions getAdmissionControllerOptions() {
        return this.admissionControllerOptions;
    }

    public PersistentVolumeConfigDetails getPersistentVolumeConfig() {
        return this.persistentVolumeConfig;
    }

    public ServiceLbConfigDetails getServiceLbConfig() {
        return this.serviceLbConfig;
    }

    public OpenIdConnectTokenAuthenticationConfig getOpenIdConnectTokenAuthenticationConfig() {
        return this.openIdConnectTokenAuthenticationConfig;
    }

    public OpenIdConnectDiscovery getOpenIdConnectDiscovery() {
        return this.openIdConnectDiscovery;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterCreateOptions(");
        sb.append("super=").append(super.toString());
        sb.append("serviceLbSubnetIds=").append(String.valueOf(this.serviceLbSubnetIds));
        sb.append(", kubernetesNetworkConfig=").append(String.valueOf((Object)this.kubernetesNetworkConfig));
        sb.append(", addOns=").append(String.valueOf((Object)this.addOns));
        sb.append(", admissionControllerOptions=").append(String.valueOf((Object)this.admissionControllerOptions));
        sb.append(", persistentVolumeConfig=").append(String.valueOf((Object)this.persistentVolumeConfig));
        sb.append(", serviceLbConfig=").append(String.valueOf((Object)this.serviceLbConfig));
        sb.append(", openIdConnectTokenAuthenticationConfig=").append(String.valueOf((Object)this.openIdConnectTokenAuthenticationConfig));
        sb.append(", openIdConnectDiscovery=").append(String.valueOf((Object)this.openIdConnectDiscovery));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterCreateOptions)) {
            return false;
        }
        ClusterCreateOptions other = (ClusterCreateOptions)((Object)o);
        return Objects.equals(this.serviceLbSubnetIds, other.serviceLbSubnetIds) && Objects.equals((Object)this.kubernetesNetworkConfig, (Object)other.kubernetesNetworkConfig) && Objects.equals((Object)this.addOns, (Object)other.addOns) && Objects.equals((Object)this.admissionControllerOptions, (Object)other.admissionControllerOptions) && Objects.equals((Object)this.persistentVolumeConfig, (Object)other.persistentVolumeConfig) && Objects.equals((Object)this.serviceLbConfig, (Object)other.serviceLbConfig) && Objects.equals((Object)this.openIdConnectTokenAuthenticationConfig, (Object)other.openIdConnectTokenAuthenticationConfig) && Objects.equals((Object)this.openIdConnectDiscovery, (Object)other.openIdConnectDiscovery) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.serviceLbSubnetIds == null ? 43 : this.serviceLbSubnetIds.hashCode());
        result = result * 59 + (this.kubernetesNetworkConfig == null ? 43 : this.kubernetesNetworkConfig.hashCode());
        result = result * 59 + (this.addOns == null ? 43 : this.addOns.hashCode());
        result = result * 59 + (this.admissionControllerOptions == null ? 43 : this.admissionControllerOptions.hashCode());
        result = result * 59 + (this.persistentVolumeConfig == null ? 43 : this.persistentVolumeConfig.hashCode());
        result = result * 59 + (this.serviceLbConfig == null ? 43 : this.serviceLbConfig.hashCode());
        result = result * 59 + (this.openIdConnectTokenAuthenticationConfig == null ? 43 : this.openIdConnectTokenAuthenticationConfig.hashCode());
        result = result * 59 + (this.openIdConnectDiscovery == null ? 43 : this.openIdConnectDiscovery.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serviceLbSubnetIds")
        private List<String> serviceLbSubnetIds;
        @JsonProperty(value="kubernetesNetworkConfig")
        private KubernetesNetworkConfig kubernetesNetworkConfig;
        @JsonProperty(value="addOns")
        private AddOnOptions addOns;
        @JsonProperty(value="admissionControllerOptions")
        private AdmissionControllerOptions admissionControllerOptions;
        @JsonProperty(value="persistentVolumeConfig")
        private PersistentVolumeConfigDetails persistentVolumeConfig;
        @JsonProperty(value="serviceLbConfig")
        private ServiceLbConfigDetails serviceLbConfig;
        @JsonProperty(value="openIdConnectTokenAuthenticationConfig")
        private OpenIdConnectTokenAuthenticationConfig openIdConnectTokenAuthenticationConfig;
        @JsonProperty(value="openIdConnectDiscovery")
        private OpenIdConnectDiscovery openIdConnectDiscovery;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serviceLbSubnetIds(List<String> serviceLbSubnetIds) {
            this.serviceLbSubnetIds = serviceLbSubnetIds;
            this.__explicitlySet__.add("serviceLbSubnetIds");
            return this;
        }

        public Builder kubernetesNetworkConfig(KubernetesNetworkConfig kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            this.__explicitlySet__.add("kubernetesNetworkConfig");
            return this;
        }

        public Builder addOns(AddOnOptions addOns) {
            this.addOns = addOns;
            this.__explicitlySet__.add("addOns");
            return this;
        }

        public Builder admissionControllerOptions(AdmissionControllerOptions admissionControllerOptions) {
            this.admissionControllerOptions = admissionControllerOptions;
            this.__explicitlySet__.add("admissionControllerOptions");
            return this;
        }

        public Builder persistentVolumeConfig(PersistentVolumeConfigDetails persistentVolumeConfig) {
            this.persistentVolumeConfig = persistentVolumeConfig;
            this.__explicitlySet__.add("persistentVolumeConfig");
            return this;
        }

        public Builder serviceLbConfig(ServiceLbConfigDetails serviceLbConfig) {
            this.serviceLbConfig = serviceLbConfig;
            this.__explicitlySet__.add("serviceLbConfig");
            return this;
        }

        public Builder openIdConnectTokenAuthenticationConfig(OpenIdConnectTokenAuthenticationConfig openIdConnectTokenAuthenticationConfig) {
            this.openIdConnectTokenAuthenticationConfig = openIdConnectTokenAuthenticationConfig;
            this.__explicitlySet__.add("openIdConnectTokenAuthenticationConfig");
            return this;
        }

        public Builder openIdConnectDiscovery(OpenIdConnectDiscovery openIdConnectDiscovery) {
            this.openIdConnectDiscovery = openIdConnectDiscovery;
            this.__explicitlySet__.add("openIdConnectDiscovery");
            return this;
        }

        public ClusterCreateOptions build() {
            ClusterCreateOptions model = new ClusterCreateOptions(this.serviceLbSubnetIds, this.kubernetesNetworkConfig, this.addOns, this.admissionControllerOptions, this.persistentVolumeConfig, this.serviceLbConfig, this.openIdConnectTokenAuthenticationConfig, this.openIdConnectDiscovery);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClusterCreateOptions model) {
            if (model.wasPropertyExplicitlySet("serviceLbSubnetIds")) {
                this.serviceLbSubnetIds(model.getServiceLbSubnetIds());
            }
            if (model.wasPropertyExplicitlySet("kubernetesNetworkConfig")) {
                this.kubernetesNetworkConfig(model.getKubernetesNetworkConfig());
            }
            if (model.wasPropertyExplicitlySet("addOns")) {
                this.addOns(model.getAddOns());
            }
            if (model.wasPropertyExplicitlySet("admissionControllerOptions")) {
                this.admissionControllerOptions(model.getAdmissionControllerOptions());
            }
            if (model.wasPropertyExplicitlySet("persistentVolumeConfig")) {
                this.persistentVolumeConfig(model.getPersistentVolumeConfig());
            }
            if (model.wasPropertyExplicitlySet("serviceLbConfig")) {
                this.serviceLbConfig(model.getServiceLbConfig());
            }
            if (model.wasPropertyExplicitlySet("openIdConnectTokenAuthenticationConfig")) {
                this.openIdConnectTokenAuthenticationConfig(model.getOpenIdConnectTokenAuthenticationConfig());
            }
            if (model.wasPropertyExplicitlySet("openIdConnectDiscovery")) {
                this.openIdConnectDiscovery(model.getOpenIdConnectDiscovery());
            }
            return this;
        }
    }
}

