/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.KeyValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OpenIdConnectTokenAuthenticationConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="issuerUrl")
    private final String issuerUrl;
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="usernameClaim")
    private final String usernameClaim;
    @JsonProperty(value="usernamePrefix")
    private final String usernamePrefix;
    @JsonProperty(value="groupsClaim")
    private final String groupsClaim;
    @JsonProperty(value="groupsPrefix")
    private final String groupsPrefix;
    @JsonProperty(value="requiredClaims")
    private final List<KeyValue> requiredClaims;
    @JsonProperty(value="caCertificate")
    private final String caCertificate;
    @JsonProperty(value="signingAlgorithms")
    private final List<String> signingAlgorithms;
    @JsonProperty(value="isOpenIdConnectAuthEnabled")
    private final Boolean isOpenIdConnectAuthEnabled;

    @Deprecated
    @ConstructorProperties(value={"issuerUrl", "clientId", "usernameClaim", "usernamePrefix", "groupsClaim", "groupsPrefix", "requiredClaims", "caCertificate", "signingAlgorithms", "isOpenIdConnectAuthEnabled"})
    public OpenIdConnectTokenAuthenticationConfig(String issuerUrl, String clientId, String usernameClaim, String usernamePrefix, String groupsClaim, String groupsPrefix, List<KeyValue> requiredClaims, String caCertificate, List<String> signingAlgorithms, Boolean isOpenIdConnectAuthEnabled) {
        this.issuerUrl = issuerUrl;
        this.clientId = clientId;
        this.usernameClaim = usernameClaim;
        this.usernamePrefix = usernamePrefix;
        this.groupsClaim = groupsClaim;
        this.groupsPrefix = groupsPrefix;
        this.requiredClaims = requiredClaims;
        this.caCertificate = caCertificate;
        this.signingAlgorithms = signingAlgorithms;
        this.isOpenIdConnectAuthEnabled = isOpenIdConnectAuthEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsernameClaim() {
        return this.usernameClaim;
    }

    public String getUsernamePrefix() {
        return this.usernamePrefix;
    }

    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public String getGroupsPrefix() {
        return this.groupsPrefix;
    }

    public List<KeyValue> getRequiredClaims() {
        return this.requiredClaims;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public List<String> getSigningAlgorithms() {
        return this.signingAlgorithms;
    }

    public Boolean getIsOpenIdConnectAuthEnabled() {
        return this.isOpenIdConnectAuthEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OpenIdConnectTokenAuthenticationConfig(");
        sb.append("super=").append(super.toString());
        sb.append("issuerUrl=").append(String.valueOf(this.issuerUrl));
        sb.append(", clientId=").append(String.valueOf(this.clientId));
        sb.append(", usernameClaim=").append(String.valueOf(this.usernameClaim));
        sb.append(", usernamePrefix=").append(String.valueOf(this.usernamePrefix));
        sb.append(", groupsClaim=").append(String.valueOf(this.groupsClaim));
        sb.append(", groupsPrefix=").append(String.valueOf(this.groupsPrefix));
        sb.append(", requiredClaims=").append(String.valueOf(this.requiredClaims));
        sb.append(", caCertificate=").append(String.valueOf(this.caCertificate));
        sb.append(", signingAlgorithms=").append(String.valueOf(this.signingAlgorithms));
        sb.append(", isOpenIdConnectAuthEnabled=").append(String.valueOf(this.isOpenIdConnectAuthEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenIdConnectTokenAuthenticationConfig)) {
            return false;
        }
        OpenIdConnectTokenAuthenticationConfig other = (OpenIdConnectTokenAuthenticationConfig)((Object)o);
        return Objects.equals(this.issuerUrl, other.issuerUrl) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.usernameClaim, other.usernameClaim) && Objects.equals(this.usernamePrefix, other.usernamePrefix) && Objects.equals(this.groupsClaim, other.groupsClaim) && Objects.equals(this.groupsPrefix, other.groupsPrefix) && Objects.equals(this.requiredClaims, other.requiredClaims) && Objects.equals(this.caCertificate, other.caCertificate) && Objects.equals(this.signingAlgorithms, other.signingAlgorithms) && Objects.equals(this.isOpenIdConnectAuthEnabled, other.isOpenIdConnectAuthEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.issuerUrl == null ? 43 : this.issuerUrl.hashCode());
        result = result * 59 + (this.clientId == null ? 43 : this.clientId.hashCode());
        result = result * 59 + (this.usernameClaim == null ? 43 : this.usernameClaim.hashCode());
        result = result * 59 + (this.usernamePrefix == null ? 43 : this.usernamePrefix.hashCode());
        result = result * 59 + (this.groupsClaim == null ? 43 : this.groupsClaim.hashCode());
        result = result * 59 + (this.groupsPrefix == null ? 43 : this.groupsPrefix.hashCode());
        result = result * 59 + (this.requiredClaims == null ? 43 : this.requiredClaims.hashCode());
        result = result * 59 + (this.caCertificate == null ? 43 : this.caCertificate.hashCode());
        result = result * 59 + (this.signingAlgorithms == null ? 43 : this.signingAlgorithms.hashCode());
        result = result * 59 + (this.isOpenIdConnectAuthEnabled == null ? 43 : this.isOpenIdConnectAuthEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="issuerUrl")
        private String issuerUrl;
        @JsonProperty(value="clientId")
        private String clientId;
        @JsonProperty(value="usernameClaim")
        private String usernameClaim;
        @JsonProperty(value="usernamePrefix")
        private String usernamePrefix;
        @JsonProperty(value="groupsClaim")
        private String groupsClaim;
        @JsonProperty(value="groupsPrefix")
        private String groupsPrefix;
        @JsonProperty(value="requiredClaims")
        private List<KeyValue> requiredClaims;
        @JsonProperty(value="caCertificate")
        private String caCertificate;
        @JsonProperty(value="signingAlgorithms")
        private List<String> signingAlgorithms;
        @JsonProperty(value="isOpenIdConnectAuthEnabled")
        private Boolean isOpenIdConnectAuthEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            this.__explicitlySet__.add("issuerUrl");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.__explicitlySet__.add("clientId");
            return this;
        }

        public Builder usernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
            this.__explicitlySet__.add("usernameClaim");
            return this;
        }

        public Builder usernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
            this.__explicitlySet__.add("usernamePrefix");
            return this;
        }

        public Builder groupsClaim(String groupsClaim) {
            this.groupsClaim = groupsClaim;
            this.__explicitlySet__.add("groupsClaim");
            return this;
        }

        public Builder groupsPrefix(String groupsPrefix) {
            this.groupsPrefix = groupsPrefix;
            this.__explicitlySet__.add("groupsPrefix");
            return this;
        }

        public Builder requiredClaims(List<KeyValue> requiredClaims) {
            this.requiredClaims = requiredClaims;
            this.__explicitlySet__.add("requiredClaims");
            return this;
        }

        public Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            this.__explicitlySet__.add("caCertificate");
            return this;
        }

        public Builder signingAlgorithms(List<String> signingAlgorithms) {
            this.signingAlgorithms = signingAlgorithms;
            this.__explicitlySet__.add("signingAlgorithms");
            return this;
        }

        public Builder isOpenIdConnectAuthEnabled(Boolean isOpenIdConnectAuthEnabled) {
            this.isOpenIdConnectAuthEnabled = isOpenIdConnectAuthEnabled;
            this.__explicitlySet__.add("isOpenIdConnectAuthEnabled");
            return this;
        }

        public OpenIdConnectTokenAuthenticationConfig build() {
            OpenIdConnectTokenAuthenticationConfig model = new OpenIdConnectTokenAuthenticationConfig(this.issuerUrl, this.clientId, this.usernameClaim, this.usernamePrefix, this.groupsClaim, this.groupsPrefix, this.requiredClaims, this.caCertificate, this.signingAlgorithms, this.isOpenIdConnectAuthEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OpenIdConnectTokenAuthenticationConfig model) {
            if (model.wasPropertyExplicitlySet("issuerUrl")) {
                this.issuerUrl(model.getIssuerUrl());
            }
            if (model.wasPropertyExplicitlySet("clientId")) {
                this.clientId(model.getClientId());
            }
            if (model.wasPropertyExplicitlySet("usernameClaim")) {
                this.usernameClaim(model.getUsernameClaim());
            }
            if (model.wasPropertyExplicitlySet("usernamePrefix")) {
                this.usernamePrefix(model.getUsernamePrefix());
            }
            if (model.wasPropertyExplicitlySet("groupsClaim")) {
                this.groupsClaim(model.getGroupsClaim());
            }
            if (model.wasPropertyExplicitlySet("groupsPrefix")) {
                this.groupsPrefix(model.getGroupsPrefix());
            }
            if (model.wasPropertyExplicitlySet("requiredClaims")) {
                this.requiredClaims(model.getRequiredClaims());
            }
            if (model.wasPropertyExplicitlySet("caCertificate")) {
                this.caCertificate(model.getCaCertificate());
            }
            if (model.wasPropertyExplicitlySet("signingAlgorithms")) {
                this.signingAlgorithms(model.getSigningAlgorithms());
            }
            if (model.wasPropertyExplicitlySet("isOpenIdConnectAuthEnabled")) {
                this.isOpenIdConnectAuthEnabled(model.getIsOpenIdConnectAuthEnabled());
            }
            return this;
        }
    }
}

