/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum ContainerCapability implements BmcEnum
{
    CapNetAdmin("CAP_NET_ADMIN"),
    CapNetRaw("CAP_NET_RAW");

    private final String value;
    private static Map<String, ContainerCapability> map;

    private ContainerCapability(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static ContainerCapability create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid ContainerCapability: " + key);
    }

    static {
        map = new HashMap<String, ContainerCapability>();
        for (ContainerCapability v : ContainerCapability.values()) {
            map.put(v.getValue(), v);
        }
    }
}

