/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerinstances.model.ContainerCapabilities;
import com.oracle.bmc.containerinstances.model.SecurityContext;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="securityContextType")
@JsonFilter(value="explicitlySetFilter")
public final class LinuxSecurityContext
extends SecurityContext {
    @JsonProperty(value="runAsUser")
    private final Integer runAsUser;
    @JsonProperty(value="runAsGroup")
    private final Integer runAsGroup;
    @JsonProperty(value="isNonRootUserCheckEnabled")
    private final Boolean isNonRootUserCheckEnabled;
    @JsonProperty(value="isRootFileSystemReadonly")
    private final Boolean isRootFileSystemReadonly;
    @JsonProperty(value="capabilities")
    private final ContainerCapabilities capabilities;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LinuxSecurityContext(Integer runAsUser, Integer runAsGroup, Boolean isNonRootUserCheckEnabled, Boolean isRootFileSystemReadonly, ContainerCapabilities capabilities) {
        this.runAsUser = runAsUser;
        this.runAsGroup = runAsGroup;
        this.isNonRootUserCheckEnabled = isNonRootUserCheckEnabled;
        this.isRootFileSystemReadonly = isRootFileSystemReadonly;
        this.capabilities = capabilities;
    }

    public Integer getRunAsUser() {
        return this.runAsUser;
    }

    public Integer getRunAsGroup() {
        return this.runAsGroup;
    }

    public Boolean getIsNonRootUserCheckEnabled() {
        return this.isNonRootUserCheckEnabled;
    }

    public Boolean getIsRootFileSystemReadonly() {
        return this.isRootFileSystemReadonly;
    }

    public ContainerCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LinuxSecurityContext(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", runAsUser=").append(String.valueOf(this.runAsUser));
        sb.append(", runAsGroup=").append(String.valueOf(this.runAsGroup));
        sb.append(", isNonRootUserCheckEnabled=").append(String.valueOf(this.isNonRootUserCheckEnabled));
        sb.append(", isRootFileSystemReadonly=").append(String.valueOf(this.isRootFileSystemReadonly));
        sb.append(", capabilities=").append(String.valueOf((Object)this.capabilities));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinuxSecurityContext)) {
            return false;
        }
        LinuxSecurityContext other = (LinuxSecurityContext)((Object)o);
        return Objects.equals(this.runAsUser, other.runAsUser) && Objects.equals(this.runAsGroup, other.runAsGroup) && Objects.equals(this.isNonRootUserCheckEnabled, other.isNonRootUserCheckEnabled) && Objects.equals(this.isRootFileSystemReadonly, other.isRootFileSystemReadonly) && Objects.equals((Object)this.capabilities, (Object)other.capabilities) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.runAsUser == null ? 43 : this.runAsUser.hashCode());
        result = result * 59 + (this.runAsGroup == null ? 43 : this.runAsGroup.hashCode());
        result = result * 59 + (this.isNonRootUserCheckEnabled == null ? 43 : this.isNonRootUserCheckEnabled.hashCode());
        result = result * 59 + (this.isRootFileSystemReadonly == null ? 43 : this.isRootFileSystemReadonly.hashCode());
        result = result * 59 + (this.capabilities == null ? 43 : this.capabilities.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="runAsUser")
        private Integer runAsUser;
        @JsonProperty(value="runAsGroup")
        private Integer runAsGroup;
        @JsonProperty(value="isNonRootUserCheckEnabled")
        private Boolean isNonRootUserCheckEnabled;
        @JsonProperty(value="isRootFileSystemReadonly")
        private Boolean isRootFileSystemReadonly;
        @JsonProperty(value="capabilities")
        private ContainerCapabilities capabilities;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder runAsUser(Integer runAsUser) {
            this.runAsUser = runAsUser;
            this.__explicitlySet__.add("runAsUser");
            return this;
        }

        public Builder runAsGroup(Integer runAsGroup) {
            this.runAsGroup = runAsGroup;
            this.__explicitlySet__.add("runAsGroup");
            return this;
        }

        public Builder isNonRootUserCheckEnabled(Boolean isNonRootUserCheckEnabled) {
            this.isNonRootUserCheckEnabled = isNonRootUserCheckEnabled;
            this.__explicitlySet__.add("isNonRootUserCheckEnabled");
            return this;
        }

        public Builder isRootFileSystemReadonly(Boolean isRootFileSystemReadonly) {
            this.isRootFileSystemReadonly = isRootFileSystemReadonly;
            this.__explicitlySet__.add("isRootFileSystemReadonly");
            return this;
        }

        public Builder capabilities(ContainerCapabilities capabilities) {
            this.capabilities = capabilities;
            this.__explicitlySet__.add("capabilities");
            return this;
        }

        public LinuxSecurityContext build() {
            LinuxSecurityContext model = new LinuxSecurityContext(this.runAsUser, this.runAsGroup, this.isNonRootUserCheckEnabled, this.isRootFileSystemReadonly, this.capabilities);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LinuxSecurityContext model) {
            if (model.wasPropertyExplicitlySet("runAsUser")) {
                this.runAsUser(model.getRunAsUser());
            }
            if (model.wasPropertyExplicitlySet("runAsGroup")) {
                this.runAsGroup(model.getRunAsGroup());
            }
            if (model.wasPropertyExplicitlySet("isNonRootUserCheckEnabled")) {
                this.isNonRootUserCheckEnabled(model.getIsNonRootUserCheckEnabled());
            }
            if (model.wasPropertyExplicitlySet("isRootFileSystemReadonly")) {
                this.isRootFileSystemReadonly(model.getIsRootFileSystemReadonly());
            }
            if (model.wasPropertyExplicitlySet("capabilities")) {
                this.capabilities(model.getCapabilities());
            }
            return this;
        }
    }
}

