/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetContainerInstanceRequest
extends BmcRequest<Void> {
    private String containerInstanceId;
    private String opcRequestId;

    public String getContainerInstanceId() {
        return this.containerInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().containerInstanceId(this.containerInstanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",containerInstanceId=").append(String.valueOf(this.containerInstanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetContainerInstanceRequest)) {
            return false;
        }
        GetContainerInstanceRequest other = (GetContainerInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.containerInstanceId, other.containerInstanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.containerInstanceId == null ? 43 : this.containerInstanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetContainerInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String containerInstanceId = null;
        private String opcRequestId = null;

        public Builder containerInstanceId(String containerInstanceId) {
            this.containerInstanceId = containerInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetContainerInstanceRequest o) {
            this.containerInstanceId(o.getContainerInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetContainerInstanceRequest build() {
            GetContainerInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetContainerInstanceRequest buildWithoutInvocationCallback() {
            GetContainerInstanceRequest request = new GetContainerInstanceRequest();
            request.containerInstanceId = this.containerInstanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

