/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dashboardservice.DashboardPaginators;
import com.oracle.bmc.dashboardservice.DashboardWaiters;
import com.oracle.bmc.dashboardservice.model.Dashboard;
import com.oracle.bmc.dashboardservice.model.DashboardCollection;
import com.oracle.bmc.dashboardservice.requests.ChangeDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.CreateDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.DeleteDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.GetDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.ListDashboardsRequest;
import com.oracle.bmc.dashboardservice.requests.UpdateDashboardRequest;
import com.oracle.bmc.dashboardservice.responses.ChangeDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.CreateDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.DeleteDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.GetDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.ListDashboardsResponse;
import com.oracle.bmc.dashboardservice.responses.UpdateDashboardResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardClient
extends BaseSyncClient
implements com.oracle.bmc.dashboardservice.Dashboard {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DASHBOARD").serviceEndpointPrefix("").serviceEndpointTemplate("https://dashboard.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DashboardClient.class);
    private final DashboardWaiters waiters;
    private final DashboardPaginators paginators;

    DashboardClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Dashboard-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DashboardWaiters(executorService, this);
        this.paginators = new DashboardPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeDashboardGroupResponse changeDashboardGroup(ChangeDashboardGroupRequest request) {
        Validate.notBlank((String)request.getDashboardId(), (String)"dashboardId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDashboardGroupDetails(), "changeDashboardGroupDetails is required");
        return (ChangeDashboardGroupResponse)this.clientCall(request, ChangeDashboardGroupResponse::builder).logger(LOG, "changeDashboardGroup").serviceDetails("Dashboard", "ChangeDashboardGroup", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/Dashboard/ChangeDashboardGroup").method(Method.POST).requestBuilder(ChangeDashboardGroupRequest::builder).basePath("/20210731").appendPathParam("dashboards").appendPathParam(request.getDashboardId()).appendPathParam("actions").appendPathParam("changeDashboardGroup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDashboardGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest request) {
        Objects.requireNonNull(request.getCreateDashboardDetails(), "createDashboardDetails is required");
        return (CreateDashboardResponse)this.clientCall(request, CreateDashboardResponse::builder).logger(LOG, "createDashboard").serviceDetails("Dashboard", "CreateDashboard", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/Dashboard/CreateDashboard").method(Method.POST).requestBuilder(CreateDashboardRequest::builder).basePath("/20210731").appendPathParam("dashboards").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).hasBody().handleBody(Dashboard.class, CreateDashboardResponse.Builder::dashboard).handleResponseHeaderString("etag", CreateDashboardResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest request) {
        Validate.notBlank((String)request.getDashboardId(), (String)"dashboardId must not be blank", (Object[])new Object[0]);
        return (DeleteDashboardResponse)this.clientCall(request, DeleteDashboardResponse::builder).logger(LOG, "deleteDashboard").serviceDetails("Dashboard", "DeleteDashboard", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/Dashboard/DeleteDashboard").method(Method.DELETE).requestBuilder(DeleteDashboardRequest::builder).basePath("/20210731").appendPathParam("dashboards").appendPathParam(request.getDashboardId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).handleResponseHeaderString("opc-request-id", DeleteDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDashboardResponse getDashboard(GetDashboardRequest request) {
        Validate.notBlank((String)request.getDashboardId(), (String)"dashboardId must not be blank", (Object[])new Object[0]);
        return (GetDashboardResponse)this.clientCall(request, GetDashboardResponse::builder).logger(LOG, "getDashboard").serviceDetails("Dashboard", "GetDashboard", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/Dashboard/GetDashboard").method(Method.GET).requestBuilder(GetDashboardRequest::builder).basePath("/20210731").appendPathParam("dashboards").appendPathParam(request.getDashboardId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).operationUsesDefaultRetries().handleBody(Dashboard.class, GetDashboardResponse.Builder::dashboard).handleResponseHeaderString("etag", GetDashboardResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDashboardsResponse listDashboards(ListDashboardsRequest request) {
        Objects.requireNonNull(request.getDashboardGroupId(), "dashboardGroupId is required");
        return (ListDashboardsResponse)this.clientCall(request, ListDashboardsResponse::builder).logger(LOG, "listDashboards").serviceDetails("Dashboard", "ListDashboards", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/DashboardCollection/ListDashboards").method(Method.GET).requestBuilder(ListDashboardsRequest::builder).basePath("/20210731").appendPathParam("dashboards").appendQueryParam("dashboardGroupId", (Object)request.getDashboardGroupId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).operationUsesDefaultRetries().handleBody(DashboardCollection.class, ListDashboardsResponse.Builder::dashboardCollection).handleResponseHeaderString("opc-request-id", ListDashboardsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDashboardsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateDashboardResponse updateDashboard(UpdateDashboardRequest request) {
        Validate.notBlank((String)request.getDashboardId(), (String)"dashboardId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDashboardDetails(), "updateDashboardDetails is required");
        return (UpdateDashboardResponse)this.clientCall(request, UpdateDashboardResponse::builder).logger(LOG, "updateDashboard").serviceDetails("Dashboard", "UpdateDashboard", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/Dashboard/UpdateDashboard").method(Method.PUT).requestBuilder(UpdateDashboardRequest::builder).basePath("/20210731").appendPathParam("dashboards").appendPathParam(request.getDashboardId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).hasBody().handleBody(Dashboard.class, UpdateDashboardResponse.Builder::dashboard).handleResponseHeaderString("etag", UpdateDashboardResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DashboardWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DashboardPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DashboardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DashboardClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashboardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DashboardClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashboardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DashboardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashboardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DashboardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashboardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DashboardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashboardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DashboardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashboardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DashboardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashboardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DashboardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DashboardClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "dashboardservice";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"dashboardservice");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DashboardClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DashboardClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

