/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dashboardservice.DashboardGroupAsync;
import com.oracle.bmc.dashboardservice.model.DashboardGroup;
import com.oracle.bmc.dashboardservice.model.DashboardGroupCollection;
import com.oracle.bmc.dashboardservice.requests.ChangeDashboardGroupCompartmentRequest;
import com.oracle.bmc.dashboardservice.requests.CreateDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.DeleteDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.GetDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.ListDashboardGroupsRequest;
import com.oracle.bmc.dashboardservice.requests.UpdateDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.responses.ChangeDashboardGroupCompartmentResponse;
import com.oracle.bmc.dashboardservice.responses.CreateDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.DeleteDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.GetDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.ListDashboardGroupsResponse;
import com.oracle.bmc.dashboardservice.responses.UpdateDashboardGroupResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardGroupAsyncClient
extends BaseAsyncClient
implements DashboardGroupAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DASHBOARDGROUP").serviceEndpointPrefix("").serviceEndpointTemplate("https://dashboard.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DashboardGroupAsyncClient.class);

    DashboardGroupAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeDashboardGroupCompartmentResponse> changeDashboardGroupCompartment(ChangeDashboardGroupCompartmentRequest request, AsyncHandler<ChangeDashboardGroupCompartmentRequest, ChangeDashboardGroupCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDashboardGroupId(), (String)"dashboardGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDashboardGroupCompartmentDetails(), "changeDashboardGroupCompartmentDetails is required");
        return this.clientCall(request, ChangeDashboardGroupCompartmentResponse::builder).logger(LOG, "changeDashboardGroupCompartment").serviceDetails("DashboardGroup", "ChangeDashboardGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/DashboardGroup/ChangeDashboardGroupCompartment").method(Method.POST).requestBuilder(ChangeDashboardGroupCompartmentRequest::builder).basePath("/20210731").appendPathParam("dashboardGroups").appendPathParam(request.getDashboardGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDashboardGroupCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDashboardGroupResponse> createDashboardGroup(CreateDashboardGroupRequest request, AsyncHandler<CreateDashboardGroupRequest, CreateDashboardGroupResponse> handler) {
        Objects.requireNonNull(request.getCreateDashboardGroupDetails(), "createDashboardGroupDetails is required");
        return this.clientCall(request, CreateDashboardGroupResponse::builder).logger(LOG, "createDashboardGroup").serviceDetails("DashboardGroup", "CreateDashboardGroup", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/DashboardGroup/CreateDashboardGroup").method(Method.POST).requestBuilder(CreateDashboardGroupRequest::builder).basePath("/20210731").appendPathParam("dashboardGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).hasBody().handleBody(DashboardGroup.class, CreateDashboardGroupResponse.Builder::dashboardGroup).handleResponseHeaderString("etag", CreateDashboardGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDashboardGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDashboardGroupResponse> deleteDashboardGroup(DeleteDashboardGroupRequest request, AsyncHandler<DeleteDashboardGroupRequest, DeleteDashboardGroupResponse> handler) {
        Validate.notBlank((String)request.getDashboardGroupId(), (String)"dashboardGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDashboardGroupResponse::builder).logger(LOG, "deleteDashboardGroup").serviceDetails("DashboardGroup", "DeleteDashboardGroup", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/DashboardGroup/DeleteDashboardGroup").method(Method.DELETE).requestBuilder(DeleteDashboardGroupRequest::builder).basePath("/20210731").appendPathParam("dashboardGroups").appendPathParam(request.getDashboardGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).handleResponseHeaderString("opc-request-id", DeleteDashboardGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDashboardGroupResponse> getDashboardGroup(GetDashboardGroupRequest request, AsyncHandler<GetDashboardGroupRequest, GetDashboardGroupResponse> handler) {
        Validate.notBlank((String)request.getDashboardGroupId(), (String)"dashboardGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDashboardGroupResponse::builder).logger(LOG, "getDashboardGroup").serviceDetails("DashboardGroup", "GetDashboardGroup", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/DashboardGroup/GetDashboardGroup").method(Method.GET).requestBuilder(GetDashboardGroupRequest::builder).basePath("/20210731").appendPathParam("dashboardGroups").appendPathParam(request.getDashboardGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).handleBody(DashboardGroup.class, GetDashboardGroupResponse.Builder::dashboardGroup).handleResponseHeaderString("etag", GetDashboardGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDashboardGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDashboardGroupsResponse> listDashboardGroups(ListDashboardGroupsRequest request, AsyncHandler<ListDashboardGroupsRequest, ListDashboardGroupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDashboardGroupsResponse::builder).logger(LOG, "listDashboardGroups").serviceDetails("DashboardGroup", "ListDashboardGroups", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/DashboardGroupCollection/ListDashboardGroups").method(Method.GET).requestBuilder(ListDashboardGroupsRequest::builder).basePath("/20210731").appendPathParam("dashboardGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).handleBody(DashboardGroupCollection.class, ListDashboardGroupsResponse.Builder::dashboardGroupCollection).handleResponseHeaderString("opc-request-id", ListDashboardGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDashboardGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateDashboardGroupResponse> updateDashboardGroup(UpdateDashboardGroupRequest request, AsyncHandler<UpdateDashboardGroupRequest, UpdateDashboardGroupResponse> handler) {
        Validate.notBlank((String)request.getDashboardGroupId(), (String)"dashboardGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDashboardGroupDetails(), "updateDashboardGroupDetails is required");
        return this.clientCall(request, UpdateDashboardGroupResponse::builder).logger(LOG, "updateDashboardGroup").serviceDetails("DashboardGroup", "UpdateDashboardGroup", "https://docs.oracle.com/iaas/api/#/en/dashboard/20210731/DashboardGroup/UpdateDashboardGroup").method(Method.PUT).requestBuilder(UpdateDashboardGroupRequest::builder).basePath("/20210731").appendPathParam("dashboardGroups").appendPathParam(request.getDashboardGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-cross-region", request.getOpcCrossRegion()).hasBody().handleBody(DashboardGroup.class, UpdateDashboardGroupResponse.Builder::dashboardGroup).handleResponseHeaderString("etag", UpdateDashboardGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDashboardGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DashboardGroupAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DashboardGroupAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DashboardGroupAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DashboardGroupAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DashboardGroupAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DashboardGroupAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DashboardGroupAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DashboardGroupAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DashboardGroupAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DashboardGroupAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DashboardGroupAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DashboardGroupAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DashboardGroupAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DashboardGroupAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DashboardGroupAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "dashboardservice";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"dashboardservice");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DashboardGroupAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DashboardGroupAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

