/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice;

import com.oracle.bmc.dashboardservice.Dashboard;
import com.oracle.bmc.dashboardservice.model.Dashboard;
import com.oracle.bmc.dashboardservice.requests.GetDashboardRequest;
import com.oracle.bmc.dashboardservice.responses.GetDashboardResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DashboardWaiters {
    private final ExecutorService executorService;
    private final Dashboard client;

    public DashboardWaiters(ExecutorService executorService, Dashboard client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDashboardRequest, GetDashboardResponse> forDashboard(GetDashboardRequest request, Dashboard.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDashboard(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDashboardRequest, GetDashboardResponse> forDashboard(GetDashboardRequest request, Dashboard.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDashboard(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDashboardRequest, GetDashboardResponse> forDashboard(GetDashboardRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Dashboard.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDashboard(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDashboardRequest, GetDashboardResponse> forDashboard(BmcGenericWaiter waiter, GetDashboardRequest request, Dashboard.LifecycleState ... targetStates) {
        final HashSet<Dashboard.LifecycleState> targetStatesSet = new HashSet<Dashboard.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDashboardRequest, GetDashboardResponse>(){

            @Override
            public GetDashboardResponse apply(GetDashboardRequest request) {
                return DashboardWaiters.this.client.getDashboard(request);
            }
        }, (Predicate)new Predicate<GetDashboardResponse>(){

            @Override
            public boolean test(GetDashboardResponse response) {
                return targetStatesSet.contains((Object)response.getDashboard().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Dashboard.LifecycleState.Deleted)), (Object)request);
    }
}

