/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dashboardservice.model.CreateDashboardDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateDashboardRequest
extends BmcRequest<CreateDashboardDetails> {
    private CreateDashboardDetails createDashboardDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String opcCrossRegion;

    public CreateDashboardDetails getCreateDashboardDetails() {
        return this.createDashboardDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcCrossRegion() {
        return this.opcCrossRegion;
    }

    @InternalSdk
    public CreateDashboardDetails getBody$() {
        return this.createDashboardDetails;
    }

    public Builder toBuilder() {
        return new Builder().createDashboardDetails(this.createDashboardDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).opcCrossRegion(this.opcCrossRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createDashboardDetails=").append(String.valueOf((Object)this.createDashboardDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcCrossRegion=").append(String.valueOf(this.opcCrossRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDashboardRequest)) {
            return false;
        }
        CreateDashboardRequest other = (CreateDashboardRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createDashboardDetails, (Object)other.createDashboardDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcCrossRegion, other.opcCrossRegion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createDashboardDetails == null ? 43 : this.createDashboardDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcCrossRegion == null ? 43 : this.opcCrossRegion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDashboardRequest, CreateDashboardDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateDashboardDetails createDashboardDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String opcCrossRegion = null;

        public Builder createDashboardDetails(CreateDashboardDetails createDashboardDetails) {
            this.createDashboardDetails = createDashboardDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcCrossRegion(String opcCrossRegion) {
            this.opcCrossRegion = opcCrossRegion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDashboardRequest o) {
            this.createDashboardDetails(o.getCreateDashboardDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.opcCrossRegion(o.getOpcCrossRegion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDashboardRequest build() {
            CreateDashboardRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDashboardDetails body) {
            this.createDashboardDetails(body);
            return this;
        }

        public CreateDashboardRequest buildWithoutInvocationCallback() {
            CreateDashboardRequest request = new CreateDashboardRequest();
            request.createDashboardDetails = this.createDashboardDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.opcCrossRegion = this.opcCrossRegion;
            return request;
        }
    }
}

