/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice.responses;

import com.oracle.bmc.dashboardservice.model.DashboardCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListDashboardsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private DashboardCollection dashboardCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public DashboardCollection getDashboardCollection() {
        return this.dashboardCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "dashboardCollection"})
    private ListDashboardsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, DashboardCollection dashboardCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.dashboardCollection = dashboardCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",dashboardCollection=").append(String.valueOf((Object)this.dashboardCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDashboardsResponse)) {
            return false;
        }
        ListDashboardsResponse other = (ListDashboardsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.dashboardCollection, (Object)other.dashboardCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.dashboardCollection == null ? 43 : this.dashboardCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListDashboardsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private DashboardCollection dashboardCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder dashboardCollection(DashboardCollection dashboardCollection) {
            this.dashboardCollection = dashboardCollection;
            return this;
        }

        public Builder copy(ListDashboardsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.dashboardCollection(o.getDashboardCollection());
            return this;
        }

        public ListDashboardsResponse build() {
            return new ListDashboardsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.dashboardCollection);
        }
    }
}

