/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.database.Database;
import com.oracle.bmc.database.DatabasePaginators;
import com.oracle.bmc.database.DatabaseWaiters;
import com.oracle.bmc.database.internal.http.CompleteExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDataWarehouseBackupConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDatabaseBackupConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.CreateBackupConverter;
import com.oracle.bmc.database.internal.http.CreateDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.CreateDbHomeConverter;
import com.oracle.bmc.database.internal.http.CreateExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.DbNodeActionConverter;
import com.oracle.bmc.database.internal.http.DeleteAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.DeleteAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.DeleteBackupConverter;
import com.oracle.bmc.database.internal.http.DeleteDbHomeConverter;
import com.oracle.bmc.database.internal.http.FailoverDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.GenerateAutonomousDataWarehouseWalletConverter;
import com.oracle.bmc.database.internal.http.GenerateAutonomousDatabaseWalletConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDataWarehouseBackupConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDatabaseBackupConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetBackupConverter;
import com.oracle.bmc.database.internal.http.GetDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.GetDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetDbHomeConverter;
import com.oracle.bmc.database.internal.http.GetDbHomePatchConverter;
import com.oracle.bmc.database.internal.http.GetDbHomePatchHistoryEntryConverter;
import com.oracle.bmc.database.internal.http.GetDbNodeConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemPatchConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemPatchHistoryEntryConverter;
import com.oracle.bmc.database.internal.http.GetExadataIormConfigConverter;
import com.oracle.bmc.database.internal.http.GetExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.LaunchDbSystemConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDataWarehouseBackupsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDataWarehousesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDatabaseBackupsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListBackupsConverter;
import com.oracle.bmc.database.internal.http.ListDataGuardAssociationsConverter;
import com.oracle.bmc.database.internal.http.ListDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomePatchHistoryEntriesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomePatchesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomesConverter;
import com.oracle.bmc.database.internal.http.ListDbNodesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemPatchHistoryEntriesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemPatchesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemShapesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemsConverter;
import com.oracle.bmc.database.internal.http.ListDbVersionsConverter;
import com.oracle.bmc.database.internal.http.ReinstateDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.RestoreAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.RestoreAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.RestoreDatabaseConverter;
import com.oracle.bmc.database.internal.http.StartAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.StartAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.StopAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.StopAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.SwitchoverDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.TerminateDbSystemConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateDbHomeConverter;
import com.oracle.bmc.database.internal.http.UpdateDbSystemConverter;
import com.oracle.bmc.database.internal.http.UpdateExadataIormConfigConverter;
import com.oracle.bmc.database.requests.CompleteExternalBackupJobRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.CreateBackupRequest;
import com.oracle.bmc.database.requests.CreateDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.CreateDbHomeRequest;
import com.oracle.bmc.database.requests.CreateExternalBackupJobRequest;
import com.oracle.bmc.database.requests.DbNodeActionRequest;
import com.oracle.bmc.database.requests.DeleteAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.DeleteAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.DeleteBackupRequest;
import com.oracle.bmc.database.requests.DeleteDbHomeRequest;
import com.oracle.bmc.database.requests.FailoverDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDataWarehouseWalletRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GetBackupRequest;
import com.oracle.bmc.database.requests.GetDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GetDatabaseRequest;
import com.oracle.bmc.database.requests.GetDbHomePatchHistoryEntryRequest;
import com.oracle.bmc.database.requests.GetDbHomePatchRequest;
import com.oracle.bmc.database.requests.GetDbHomeRequest;
import com.oracle.bmc.database.requests.GetDbNodeRequest;
import com.oracle.bmc.database.requests.GetDbSystemPatchHistoryEntryRequest;
import com.oracle.bmc.database.requests.GetDbSystemPatchRequest;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.requests.GetExadataIormConfigRequest;
import com.oracle.bmc.database.requests.GetExternalBackupJobRequest;
import com.oracle.bmc.database.requests.LaunchDbSystemRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehouseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehousesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabaseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabasesRequest;
import com.oracle.bmc.database.requests.ListBackupsRequest;
import com.oracle.bmc.database.requests.ListDataGuardAssociationsRequest;
import com.oracle.bmc.database.requests.ListDatabasesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchesRequest;
import com.oracle.bmc.database.requests.ListDbHomesRequest;
import com.oracle.bmc.database.requests.ListDbNodesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchesRequest;
import com.oracle.bmc.database.requests.ListDbSystemShapesRequest;
import com.oracle.bmc.database.requests.ListDbSystemsRequest;
import com.oracle.bmc.database.requests.ListDbVersionsRequest;
import com.oracle.bmc.database.requests.ReinstateDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.RestoreAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.RestoreAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.RestoreDatabaseRequest;
import com.oracle.bmc.database.requests.StartAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.StartAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.StopAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.StopAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.SwitchoverDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.TerminateDbSystemRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateDbHomeRequest;
import com.oracle.bmc.database.requests.UpdateDbSystemRequest;
import com.oracle.bmc.database.requests.UpdateExadataIormConfigRequest;
import com.oracle.bmc.database.responses.CompleteExternalBackupJobResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.CreateBackupResponse;
import com.oracle.bmc.database.responses.CreateDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.CreateDbHomeResponse;
import com.oracle.bmc.database.responses.CreateExternalBackupJobResponse;
import com.oracle.bmc.database.responses.DbNodeActionResponse;
import com.oracle.bmc.database.responses.DeleteAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.DeleteAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.DeleteBackupResponse;
import com.oracle.bmc.database.responses.DeleteDbHomeResponse;
import com.oracle.bmc.database.responses.FailoverDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GenerateAutonomousDataWarehouseWalletResponse;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.GetBackupResponse;
import com.oracle.bmc.database.responses.GetDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GetDatabaseResponse;
import com.oracle.bmc.database.responses.GetDbHomePatchHistoryEntryResponse;
import com.oracle.bmc.database.responses.GetDbHomePatchResponse;
import com.oracle.bmc.database.responses.GetDbHomeResponse;
import com.oracle.bmc.database.responses.GetDbNodeResponse;
import com.oracle.bmc.database.responses.GetDbSystemPatchHistoryEntryResponse;
import com.oracle.bmc.database.responses.GetDbSystemPatchResponse;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.database.responses.GetExadataIormConfigResponse;
import com.oracle.bmc.database.responses.GetExternalBackupJobResponse;
import com.oracle.bmc.database.responses.LaunchDbSystemResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehouseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehousesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabaseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabasesResponse;
import com.oracle.bmc.database.responses.ListBackupsResponse;
import com.oracle.bmc.database.responses.ListDataGuardAssociationsResponse;
import com.oracle.bmc.database.responses.ListDatabasesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchesResponse;
import com.oracle.bmc.database.responses.ListDbHomesResponse;
import com.oracle.bmc.database.responses.ListDbNodesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchesResponse;
import com.oracle.bmc.database.responses.ListDbSystemShapesResponse;
import com.oracle.bmc.database.responses.ListDbSystemsResponse;
import com.oracle.bmc.database.responses.ListDbVersionsResponse;
import com.oracle.bmc.database.responses.ReinstateDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.RestoreAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.RestoreAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.RestoreDatabaseResponse;
import com.oracle.bmc.database.responses.StartAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.StartAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.StopAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.StopAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.SwitchoverDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.TerminateDbSystemResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateDbHomeResponse;
import com.oracle.bmc.database.responses.UpdateDbSystemResponse;
import com.oracle.bmc.database.responses.UpdateExadataIormConfigResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClient
implements Database {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASE").serviceEndpointPrefix("database").serviceEndpointTemplate("https://database.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DatabaseWaiters waiters;
    private final DatabasePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DatabaseClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DatabaseClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DatabaseClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Database-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DatabaseWaiters(executorService, this);
        this.paginators = new DatabasePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CompleteExternalBackupJobResponse completeExternalBackupJob(CompleteExternalBackupJobRequest request) {
        LOG.trace("Called completeExternalBackupJob");
        request = CompleteExternalBackupJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CompleteExternalBackupJobConverter.fromRequest(this.client, request);
        Function<Response, CompleteExternalBackupJobResponse> transformer = CompleteExternalBackupJobConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCompleteExternalBackupJobDetails(), (BmcRequest)request);
                return (CompleteExternalBackupJobResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateAutonomousDataWarehouseResponse createAutonomousDataWarehouse(CreateAutonomousDataWarehouseRequest request) {
        LOG.trace("Called createAutonomousDataWarehouse");
        request = CreateAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDataWarehouseConverter.fromRequest(this.client, request);
        Function<Response, CreateAutonomousDataWarehouseResponse> transformer = CreateAutonomousDataWarehouseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateAutonomousDataWarehouseDetails(), (BmcRequest)request);
                return (CreateAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateAutonomousDataWarehouseBackupResponse createAutonomousDataWarehouseBackup(CreateAutonomousDataWarehouseBackupRequest request) {
        LOG.trace("Called createAutonomousDataWarehouseBackup");
        request = CreateAutonomousDataWarehouseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDataWarehouseBackupConverter.fromRequest(this.client, request);
        Function<Response, CreateAutonomousDataWarehouseBackupResponse> transformer = CreateAutonomousDataWarehouseBackupConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateAutonomousDataWarehouseBackupDetails(), (BmcRequest)request);
                return (CreateAutonomousDataWarehouseBackupResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateAutonomousDatabaseResponse createAutonomousDatabase(CreateAutonomousDatabaseRequest request) {
        LOG.trace("Called createAutonomousDatabase");
        request = CreateAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDatabaseConverter.fromRequest(this.client, request);
        Function<Response, CreateAutonomousDatabaseResponse> transformer = CreateAutonomousDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateAutonomousDatabaseDetails(), (BmcRequest)request);
                return (CreateAutonomousDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateAutonomousDatabaseBackupResponse createAutonomousDatabaseBackup(CreateAutonomousDatabaseBackupRequest request) {
        LOG.trace("Called createAutonomousDatabaseBackup");
        request = CreateAutonomousDatabaseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDatabaseBackupConverter.fromRequest(this.client, request);
        Function<Response, CreateAutonomousDatabaseBackupResponse> transformer = CreateAutonomousDatabaseBackupConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateAutonomousDatabaseBackupDetails(), (BmcRequest)request);
                return (CreateAutonomousDatabaseBackupResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest request) {
        LOG.trace("Called createBackup");
        request = CreateBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackupConverter.fromRequest(this.client, request);
        Function<Response, CreateBackupResponse> transformer = CreateBackupConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateBackupDetails(), (BmcRequest)request);
                return (CreateBackupResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateDataGuardAssociationResponse createDataGuardAssociation(CreateDataGuardAssociationRequest request) {
        LOG.trace("Called createDataGuardAssociation");
        request = CreateDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataGuardAssociationConverter.fromRequest(this.client, request);
        Function<Response, CreateDataGuardAssociationResponse> transformer = CreateDataGuardAssociationConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateDataGuardAssociationDetails(), (BmcRequest)request);
                return (CreateDataGuardAssociationResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateDbHomeResponse createDbHome(CreateDbHomeRequest request) {
        LOG.trace("Called createDbHome");
        request = CreateDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDbHomeConverter.fromRequest(this.client, request);
        Function<Response, CreateDbHomeResponse> transformer = CreateDbHomeConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateDbHomeWithDbSystemIdDetails(), (BmcRequest)request);
                return (CreateDbHomeResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public CreateExternalBackupJobResponse createExternalBackupJob(CreateExternalBackupJobRequest request) {
        LOG.trace("Called createExternalBackupJob");
        request = CreateExternalBackupJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExternalBackupJobConverter.fromRequest(this.client, request);
        Function<Response, CreateExternalBackupJobResponse> transformer = CreateExternalBackupJobConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getCreateExternalBackupJobDetails(), (BmcRequest)request);
                return (CreateExternalBackupJobResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public DbNodeActionResponse dbNodeAction(DbNodeActionRequest request) {
        LOG.trace("Called dbNodeAction");
        request = DbNodeActionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DbNodeActionConverter.fromRequest(this.client, request);
        Function<Response, DbNodeActionResponse> transformer = DbNodeActionConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (BmcRequest)request);
                return (DbNodeActionResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public DeleteAutonomousDataWarehouseResponse deleteAutonomousDataWarehouse(DeleteAutonomousDataWarehouseRequest request) {
        LOG.trace("Called deleteAutonomousDataWarehouse");
        request = DeleteAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutonomousDataWarehouseConverter.fromRequest(this.client, request);
        Function<Response, DeleteAutonomousDataWarehouseResponse> transformer = DeleteAutonomousDataWarehouseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.delete(ib, (BmcRequest)request);
                return (DeleteAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public DeleteAutonomousDatabaseResponse deleteAutonomousDatabase(DeleteAutonomousDatabaseRequest request) {
        LOG.trace("Called deleteAutonomousDatabase");
        request = DeleteAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutonomousDatabaseConverter.fromRequest(this.client, request);
        Function<Response, DeleteAutonomousDatabaseResponse> transformer = DeleteAutonomousDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.delete(ib, (BmcRequest)request);
                return (DeleteAutonomousDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest request) {
        LOG.trace("Called deleteBackup");
        request = DeleteBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackupConverter.fromRequest(this.client, request);
        Function<Response, DeleteBackupResponse> transformer = DeleteBackupConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.delete(ib, (BmcRequest)request);
                return (DeleteBackupResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public DeleteDbHomeResponse deleteDbHome(DeleteDbHomeRequest request) {
        LOG.trace("Called deleteDbHome");
        request = DeleteDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDbHomeConverter.fromRequest(this.client, request);
        Function<Response, DeleteDbHomeResponse> transformer = DeleteDbHomeConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.delete(ib, (BmcRequest)request);
                return (DeleteDbHomeResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public FailoverDataGuardAssociationResponse failoverDataGuardAssociation(FailoverDataGuardAssociationRequest request) {
        LOG.trace("Called failoverDataGuardAssociation");
        request = FailoverDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = FailoverDataGuardAssociationConverter.fromRequest(this.client, request);
        Function<Response, FailoverDataGuardAssociationResponse> transformer = FailoverDataGuardAssociationConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getFailoverDataGuardAssociationDetails(), (BmcRequest)request);
                return (FailoverDataGuardAssociationResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GenerateAutonomousDataWarehouseWalletResponse generateAutonomousDataWarehouseWallet(GenerateAutonomousDataWarehouseWalletRequest request) {
        LOG.trace("Called generateAutonomousDataWarehouseWallet");
        request = GenerateAutonomousDataWarehouseWalletConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateAutonomousDataWarehouseWalletConverter.fromRequest(this.client, request);
        Function<Response, GenerateAutonomousDataWarehouseWalletResponse> transformer = GenerateAutonomousDataWarehouseWalletConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getGenerateAutonomousDataWarehouseWalletDetails(), (BmcRequest)request);
                return (GenerateAutonomousDataWarehouseWalletResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(GenerateAutonomousDatabaseWalletRequest request) {
        LOG.trace("Called generateAutonomousDatabaseWallet");
        request = GenerateAutonomousDatabaseWalletConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateAutonomousDatabaseWalletConverter.fromRequest(this.client, request);
        Function<Response, GenerateAutonomousDatabaseWalletResponse> transformer = GenerateAutonomousDatabaseWalletConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getGenerateAutonomousDatabaseWalletDetails(), (BmcRequest)request);
                return (GenerateAutonomousDatabaseWalletResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetAutonomousDataWarehouseResponse getAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request) {
        LOG.trace("Called getAutonomousDataWarehouse");
        request = GetAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDataWarehouseConverter.fromRequest(this.client, request);
        Function<Response, GetAutonomousDataWarehouseResponse> transformer = GetAutonomousDataWarehouseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetAutonomousDataWarehouseBackupResponse getAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request) {
        LOG.trace("Called getAutonomousDataWarehouseBackup");
        request = GetAutonomousDataWarehouseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDataWarehouseBackupConverter.fromRequest(this.client, request);
        Function<Response, GetAutonomousDataWarehouseBackupResponse> transformer = GetAutonomousDataWarehouseBackupConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetAutonomousDataWarehouseBackupResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetAutonomousDatabaseResponse getAutonomousDatabase(GetAutonomousDatabaseRequest request) {
        LOG.trace("Called getAutonomousDatabase");
        request = GetAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDatabaseConverter.fromRequest(this.client, request);
        Function<Response, GetAutonomousDatabaseResponse> transformer = GetAutonomousDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetAutonomousDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetAutonomousDatabaseBackupResponse getAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request) {
        LOG.trace("Called getAutonomousDatabaseBackup");
        request = GetAutonomousDatabaseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDatabaseBackupConverter.fromRequest(this.client, request);
        Function<Response, GetAutonomousDatabaseBackupResponse> transformer = GetAutonomousDatabaseBackupConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetAutonomousDatabaseBackupResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetBackupResponse getBackup(GetBackupRequest request) {
        LOG.trace("Called getBackup");
        request = GetBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackupConverter.fromRequest(this.client, request);
        Function<Response, GetBackupResponse> transformer = GetBackupConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetBackupResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDataGuardAssociationResponse getDataGuardAssociation(GetDataGuardAssociationRequest request) {
        LOG.trace("Called getDataGuardAssociation");
        request = GetDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataGuardAssociationConverter.fromRequest(this.client, request);
        Function<Response, GetDataGuardAssociationResponse> transformer = GetDataGuardAssociationConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDataGuardAssociationResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDatabaseResponse getDatabase(GetDatabaseRequest request) {
        LOG.trace("Called getDatabase");
        request = GetDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseConverter.fromRequest(this.client, request);
        Function<Response, GetDatabaseResponse> transformer = GetDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDbHomeResponse getDbHome(GetDbHomeRequest request) {
        LOG.trace("Called getDbHome");
        request = GetDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbHomeConverter.fromRequest(this.client, request);
        Function<Response, GetDbHomeResponse> transformer = GetDbHomeConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDbHomeResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDbHomePatchResponse getDbHomePatch(GetDbHomePatchRequest request) {
        LOG.trace("Called getDbHomePatch");
        request = GetDbHomePatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbHomePatchConverter.fromRequest(this.client, request);
        Function<Response, GetDbHomePatchResponse> transformer = GetDbHomePatchConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDbHomePatchResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDbHomePatchHistoryEntryResponse getDbHomePatchHistoryEntry(GetDbHomePatchHistoryEntryRequest request) {
        LOG.trace("Called getDbHomePatchHistoryEntry");
        request = GetDbHomePatchHistoryEntryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbHomePatchHistoryEntryConverter.fromRequest(this.client, request);
        Function<Response, GetDbHomePatchHistoryEntryResponse> transformer = GetDbHomePatchHistoryEntryConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDbHomePatchHistoryEntryResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDbNodeResponse getDbNode(GetDbNodeRequest request) {
        LOG.trace("Called getDbNode");
        request = GetDbNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbNodeConverter.fromRequest(this.client, request);
        Function<Response, GetDbNodeResponse> transformer = GetDbNodeConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDbNodeResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDbSystemResponse getDbSystem(GetDbSystemRequest request) {
        LOG.trace("Called getDbSystem");
        request = GetDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemConverter.fromRequest(this.client, request);
        Function<Response, GetDbSystemResponse> transformer = GetDbSystemConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDbSystemResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDbSystemPatchResponse getDbSystemPatch(GetDbSystemPatchRequest request) {
        LOG.trace("Called getDbSystemPatch");
        request = GetDbSystemPatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemPatchConverter.fromRequest(this.client, request);
        Function<Response, GetDbSystemPatchResponse> transformer = GetDbSystemPatchConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDbSystemPatchResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetDbSystemPatchHistoryEntryResponse getDbSystemPatchHistoryEntry(GetDbSystemPatchHistoryEntryRequest request) {
        LOG.trace("Called getDbSystemPatchHistoryEntry");
        request = GetDbSystemPatchHistoryEntryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemPatchHistoryEntryConverter.fromRequest(this.client, request);
        Function<Response, GetDbSystemPatchHistoryEntryResponse> transformer = GetDbSystemPatchHistoryEntryConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetDbSystemPatchHistoryEntryResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetExadataIormConfigResponse getExadataIormConfig(GetExadataIormConfigRequest request) {
        LOG.trace("Called getExadataIormConfig");
        request = GetExadataIormConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExadataIormConfigConverter.fromRequest(this.client, request);
        Function<Response, GetExadataIormConfigResponse> transformer = GetExadataIormConfigConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetExadataIormConfigResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public GetExternalBackupJobResponse getExternalBackupJob(GetExternalBackupJobRequest request) {
        LOG.trace("Called getExternalBackupJob");
        request = GetExternalBackupJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExternalBackupJobConverter.fromRequest(this.client, request);
        Function<Response, GetExternalBackupJobResponse> transformer = GetExternalBackupJobConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (GetExternalBackupJobResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public LaunchDbSystemResponse launchDbSystem(LaunchDbSystemRequest request) {
        LOG.trace("Called launchDbSystem");
        request = LaunchDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = LaunchDbSystemConverter.fromRequest(this.client, request);
        Function<Response, LaunchDbSystemResponse> transformer = LaunchDbSystemConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getLaunchDbSystemDetails(), (BmcRequest)request);
                return (LaunchDbSystemResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListAutonomousDataWarehouseBackupsResponse listAutonomousDataWarehouseBackups(ListAutonomousDataWarehouseBackupsRequest request) {
        LOG.trace("Called listAutonomousDataWarehouseBackups");
        request = ListAutonomousDataWarehouseBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDataWarehouseBackupsConverter.fromRequest(this.client, request);
        Function<Response, ListAutonomousDataWarehouseBackupsResponse> transformer = ListAutonomousDataWarehouseBackupsConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListAutonomousDataWarehouseBackupsResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListAutonomousDataWarehousesResponse listAutonomousDataWarehouses(ListAutonomousDataWarehousesRequest request) {
        LOG.trace("Called listAutonomousDataWarehouses");
        request = ListAutonomousDataWarehousesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDataWarehousesConverter.fromRequest(this.client, request);
        Function<Response, ListAutonomousDataWarehousesResponse> transformer = ListAutonomousDataWarehousesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListAutonomousDataWarehousesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListAutonomousDatabaseBackupsResponse listAutonomousDatabaseBackups(ListAutonomousDatabaseBackupsRequest request) {
        LOG.trace("Called listAutonomousDatabaseBackups");
        request = ListAutonomousDatabaseBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDatabaseBackupsConverter.fromRequest(this.client, request);
        Function<Response, ListAutonomousDatabaseBackupsResponse> transformer = ListAutonomousDatabaseBackupsConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListAutonomousDatabaseBackupsResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListAutonomousDatabasesResponse listAutonomousDatabases(ListAutonomousDatabasesRequest request) {
        LOG.trace("Called listAutonomousDatabases");
        request = ListAutonomousDatabasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDatabasesConverter.fromRequest(this.client, request);
        Function<Response, ListAutonomousDatabasesResponse> transformer = ListAutonomousDatabasesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListAutonomousDatabasesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListBackupsResponse listBackups(ListBackupsRequest request) {
        LOG.trace("Called listBackups");
        request = ListBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackupsConverter.fromRequest(this.client, request);
        Function<Response, ListBackupsResponse> transformer = ListBackupsConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListBackupsResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDataGuardAssociationsResponse listDataGuardAssociations(ListDataGuardAssociationsRequest request) {
        LOG.trace("Called listDataGuardAssociations");
        request = ListDataGuardAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataGuardAssociationsConverter.fromRequest(this.client, request);
        Function<Response, ListDataGuardAssociationsResponse> transformer = ListDataGuardAssociationsConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDataGuardAssociationsResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest request) {
        LOG.trace("Called listDatabases");
        request = ListDatabasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDatabasesConverter.fromRequest(this.client, request);
        Function<Response, ListDatabasesResponse> transformer = ListDatabasesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDatabasesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbHomePatchHistoryEntriesResponse listDbHomePatchHistoryEntries(ListDbHomePatchHistoryEntriesRequest request) {
        LOG.trace("Called listDbHomePatchHistoryEntries");
        request = ListDbHomePatchHistoryEntriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbHomePatchHistoryEntriesConverter.fromRequest(this.client, request);
        Function<Response, ListDbHomePatchHistoryEntriesResponse> transformer = ListDbHomePatchHistoryEntriesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbHomePatchHistoryEntriesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbHomePatchesResponse listDbHomePatches(ListDbHomePatchesRequest request) {
        LOG.trace("Called listDbHomePatches");
        request = ListDbHomePatchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbHomePatchesConverter.fromRequest(this.client, request);
        Function<Response, ListDbHomePatchesResponse> transformer = ListDbHomePatchesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbHomePatchesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbHomesResponse listDbHomes(ListDbHomesRequest request) {
        LOG.trace("Called listDbHomes");
        request = ListDbHomesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbHomesConverter.fromRequest(this.client, request);
        Function<Response, ListDbHomesResponse> transformer = ListDbHomesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbHomesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbNodesResponse listDbNodes(ListDbNodesRequest request) {
        LOG.trace("Called listDbNodes");
        request = ListDbNodesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbNodesConverter.fromRequest(this.client, request);
        Function<Response, ListDbNodesResponse> transformer = ListDbNodesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbNodesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbSystemPatchHistoryEntriesResponse listDbSystemPatchHistoryEntries(ListDbSystemPatchHistoryEntriesRequest request) {
        LOG.trace("Called listDbSystemPatchHistoryEntries");
        request = ListDbSystemPatchHistoryEntriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemPatchHistoryEntriesConverter.fromRequest(this.client, request);
        Function<Response, ListDbSystemPatchHistoryEntriesResponse> transformer = ListDbSystemPatchHistoryEntriesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbSystemPatchHistoryEntriesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbSystemPatchesResponse listDbSystemPatches(ListDbSystemPatchesRequest request) {
        LOG.trace("Called listDbSystemPatches");
        request = ListDbSystemPatchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemPatchesConverter.fromRequest(this.client, request);
        Function<Response, ListDbSystemPatchesResponse> transformer = ListDbSystemPatchesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbSystemPatchesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbSystemShapesResponse listDbSystemShapes(ListDbSystemShapesRequest request) {
        LOG.trace("Called listDbSystemShapes");
        request = ListDbSystemShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemShapesConverter.fromRequest(this.client, request);
        Function<Response, ListDbSystemShapesResponse> transformer = ListDbSystemShapesConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbSystemShapesResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbSystemsResponse listDbSystems(ListDbSystemsRequest request) {
        LOG.trace("Called listDbSystems");
        request = ListDbSystemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemsConverter.fromRequest(this.client, request);
        Function<Response, ListDbSystemsResponse> transformer = ListDbSystemsConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbSystemsResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ListDbVersionsResponse listDbVersions(ListDbVersionsRequest request) {
        LOG.trace("Called listDbVersions");
        request = ListDbVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbVersionsConverter.fromRequest(this.client, request);
        Function<Response, ListDbVersionsResponse> transformer = ListDbVersionsConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.get(ib, (BmcRequest)request);
                return (ListDbVersionsResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public ReinstateDataGuardAssociationResponse reinstateDataGuardAssociation(ReinstateDataGuardAssociationRequest request) {
        LOG.trace("Called reinstateDataGuardAssociation");
        request = ReinstateDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReinstateDataGuardAssociationConverter.fromRequest(this.client, request);
        Function<Response, ReinstateDataGuardAssociationResponse> transformer = ReinstateDataGuardAssociationConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getReinstateDataGuardAssociationDetails(), (BmcRequest)request);
                return (ReinstateDataGuardAssociationResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public RestoreAutonomousDataWarehouseResponse restoreAutonomousDataWarehouse(RestoreAutonomousDataWarehouseRequest request) {
        LOG.trace("Called restoreAutonomousDataWarehouse");
        request = RestoreAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreAutonomousDataWarehouseConverter.fromRequest(this.client, request);
        Function<Response, RestoreAutonomousDataWarehouseResponse> transformer = RestoreAutonomousDataWarehouseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getRestoreAutonomousDataWarehouseDetails(), (BmcRequest)request);
                return (RestoreAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public RestoreAutonomousDatabaseResponse restoreAutonomousDatabase(RestoreAutonomousDatabaseRequest request) {
        LOG.trace("Called restoreAutonomousDatabase");
        request = RestoreAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreAutonomousDatabaseConverter.fromRequest(this.client, request);
        Function<Response, RestoreAutonomousDatabaseResponse> transformer = RestoreAutonomousDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getRestoreAutonomousDatabaseDetails(), (BmcRequest)request);
                return (RestoreAutonomousDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public RestoreDatabaseResponse restoreDatabase(RestoreDatabaseRequest request) {
        LOG.trace("Called restoreDatabase");
        request = RestoreDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreDatabaseConverter.fromRequest(this.client, request);
        Function<Response, RestoreDatabaseResponse> transformer = RestoreDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getRestoreDatabaseDetails(), (BmcRequest)request);
                return (RestoreDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public StartAutonomousDataWarehouseResponse startAutonomousDataWarehouse(StartAutonomousDataWarehouseRequest request) {
        LOG.trace("Called startAutonomousDataWarehouse");
        request = StartAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAutonomousDataWarehouseConverter.fromRequest(this.client, request);
        Function<Response, StartAutonomousDataWarehouseResponse> transformer = StartAutonomousDataWarehouseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (BmcRequest)request);
                return (StartAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public StartAutonomousDatabaseResponse startAutonomousDatabase(StartAutonomousDatabaseRequest request) {
        LOG.trace("Called startAutonomousDatabase");
        request = StartAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAutonomousDatabaseConverter.fromRequest(this.client, request);
        Function<Response, StartAutonomousDatabaseResponse> transformer = StartAutonomousDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (BmcRequest)request);
                return (StartAutonomousDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public StopAutonomousDataWarehouseResponse stopAutonomousDataWarehouse(StopAutonomousDataWarehouseRequest request) {
        LOG.trace("Called stopAutonomousDataWarehouse");
        request = StopAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAutonomousDataWarehouseConverter.fromRequest(this.client, request);
        Function<Response, StopAutonomousDataWarehouseResponse> transformer = StopAutonomousDataWarehouseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (BmcRequest)request);
                return (StopAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public StopAutonomousDatabaseResponse stopAutonomousDatabase(StopAutonomousDatabaseRequest request) {
        LOG.trace("Called stopAutonomousDatabase");
        request = StopAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAutonomousDatabaseConverter.fromRequest(this.client, request);
        Function<Response, StopAutonomousDatabaseResponse> transformer = StopAutonomousDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (BmcRequest)request);
                return (StopAutonomousDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public SwitchoverDataGuardAssociationResponse switchoverDataGuardAssociation(SwitchoverDataGuardAssociationRequest request) {
        LOG.trace("Called switchoverDataGuardAssociation");
        request = SwitchoverDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SwitchoverDataGuardAssociationConverter.fromRequest(this.client, request);
        Function<Response, SwitchoverDataGuardAssociationResponse> transformer = SwitchoverDataGuardAssociationConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.post(ib, (Object)request.getSwitchoverDataGuardAssociationDetails(), (BmcRequest)request);
                return (SwitchoverDataGuardAssociationResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public TerminateDbSystemResponse terminateDbSystem(TerminateDbSystemRequest request) {
        LOG.trace("Called terminateDbSystem");
        request = TerminateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TerminateDbSystemConverter.fromRequest(this.client, request);
        Function<Response, TerminateDbSystemResponse> transformer = TerminateDbSystemConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.delete(ib, (BmcRequest)request);
                return (TerminateDbSystemResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public UpdateAutonomousDataWarehouseResponse updateAutonomousDataWarehouse(UpdateAutonomousDataWarehouseRequest request) {
        LOG.trace("Called updateAutonomousDataWarehouse");
        request = UpdateAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutonomousDataWarehouseConverter.fromRequest(this.client, request);
        Function<Response, UpdateAutonomousDataWarehouseResponse> transformer = UpdateAutonomousDataWarehouseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.put(ib, (Object)request.getUpdateAutonomousDataWarehouseDetails(), (BmcRequest)request);
                return (UpdateAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public UpdateAutonomousDatabaseResponse updateAutonomousDatabase(UpdateAutonomousDatabaseRequest request) {
        LOG.trace("Called updateAutonomousDatabase");
        request = UpdateAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutonomousDatabaseConverter.fromRequest(this.client, request);
        Function<Response, UpdateAutonomousDatabaseResponse> transformer = UpdateAutonomousDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.put(ib, (Object)request.getUpdateAutonomousDatabaseDetails(), (BmcRequest)request);
                return (UpdateAutonomousDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public UpdateDatabaseResponse updateDatabase(UpdateDatabaseRequest request) {
        LOG.trace("Called updateDatabase");
        request = UpdateDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDatabaseConverter.fromRequest(this.client, request);
        Function<Response, UpdateDatabaseResponse> transformer = UpdateDatabaseConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.put(ib, (Object)request.getUpdateDatabaseDetails(), (BmcRequest)request);
                return (UpdateDatabaseResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public UpdateDbHomeResponse updateDbHome(UpdateDbHomeRequest request) {
        LOG.trace("Called updateDbHome");
        request = UpdateDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDbHomeConverter.fromRequest(this.client, request);
        Function<Response, UpdateDbHomeResponse> transformer = UpdateDbHomeConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.put(ib, (Object)request.getUpdateDbHomeDetails(), (BmcRequest)request);
                return (UpdateDbHomeResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public UpdateDbSystemResponse updateDbSystem(UpdateDbSystemRequest request) {
        LOG.trace("Called updateDbSystem");
        request = UpdateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDbSystemConverter.fromRequest(this.client, request);
        Function<Response, UpdateDbSystemResponse> transformer = UpdateDbSystemConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.put(ib, (Object)request.getUpdateDbSystemDetails(), (BmcRequest)request);
                return (UpdateDbSystemResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public UpdateExadataIormConfigResponse updateExadataIormConfig(UpdateExadataIormConfigRequest request) {
        LOG.trace("Called updateExadataIormConfig");
        request = UpdateExadataIormConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExadataIormConfigConverter.fromRequest(this.client, request);
        Function<Response, UpdateExadataIormConfigResponse> transformer = UpdateExadataIormConfigConverter.fromResponse();
        int attempts = 0;
        while (true) {
            try {
                Response response = this.client.put(ib, (Object)request.getExadataIormConfigUpdateDetails(), (BmcRequest)request);
                return (UpdateExadataIormConfigResponse)transformer.apply((Object)response);
            }
            catch (BmcException e) {
                if (++attempts < 2 && this.canRetryRequestIfRefreshableAuthTokenUsed(e)) continue;
                throw e;
            }
            break;
        }
    }

    private boolean canRetryRequestIfRefreshableAuthTokenUsed(BmcException e) {
        if (e.getStatusCode() == 401 && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            ((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider).refresh();
            return true;
        }
        return false;
    }

    @Override
    public DatabaseWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DatabasePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DatabaseClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider");
            }
            return new DatabaseClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

