/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.database.Database;
import com.oracle.bmc.database.model.AutonomousDataWarehouseBackupSummary;
import com.oracle.bmc.database.model.AutonomousDataWarehouseSummary;
import com.oracle.bmc.database.model.AutonomousDatabaseBackupSummary;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.database.model.BackupSummary;
import com.oracle.bmc.database.model.DataGuardAssociationSummary;
import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.database.model.DbHomeSummary;
import com.oracle.bmc.database.model.DbNodeSummary;
import com.oracle.bmc.database.model.DbSystemShapeSummary;
import com.oracle.bmc.database.model.DbSystemSummary;
import com.oracle.bmc.database.model.DbVersionSummary;
import com.oracle.bmc.database.model.PatchHistoryEntrySummary;
import com.oracle.bmc.database.model.PatchSummary;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehouseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehousesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabaseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabasesRequest;
import com.oracle.bmc.database.requests.ListBackupsRequest;
import com.oracle.bmc.database.requests.ListDataGuardAssociationsRequest;
import com.oracle.bmc.database.requests.ListDatabasesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchesRequest;
import com.oracle.bmc.database.requests.ListDbHomesRequest;
import com.oracle.bmc.database.requests.ListDbNodesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchesRequest;
import com.oracle.bmc.database.requests.ListDbSystemShapesRequest;
import com.oracle.bmc.database.requests.ListDbSystemsRequest;
import com.oracle.bmc.database.requests.ListDbVersionsRequest;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehouseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehousesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabaseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabasesResponse;
import com.oracle.bmc.database.responses.ListBackupsResponse;
import com.oracle.bmc.database.responses.ListDataGuardAssociationsResponse;
import com.oracle.bmc.database.responses.ListDatabasesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchesResponse;
import com.oracle.bmc.database.responses.ListDbHomesResponse;
import com.oracle.bmc.database.responses.ListDbNodesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchesResponse;
import com.oracle.bmc.database.responses.ListDbSystemShapesResponse;
import com.oracle.bmc.database.responses.ListDbSystemsResponse;
import com.oracle.bmc.database.responses.ListDbVersionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DatabasePaginators {
    private final Database client;

    public Iterable<ListAutonomousDataWarehouseBackupsResponse> listAutonomousDataWarehouseBackupsResponseIterator(final ListAutonomousDataWarehouseBackupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAutonomousDataWarehouseBackupsRequest.Builder>(){

            public ListAutonomousDataWarehouseBackupsRequest.Builder get() {
                return ListAutonomousDataWarehouseBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDataWarehouseBackupsResponse, String>(){

            public String apply(ListAutonomousDataWarehouseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder>, ListAutonomousDataWarehouseBackupsRequest>(){

            public ListAutonomousDataWarehouseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDataWarehouseBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDataWarehouseBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>(){

            public ListAutonomousDataWarehouseBackupsResponse apply(ListAutonomousDataWarehouseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouseBackups(request);
            }
        });
    }

    public Iterable<AutonomousDataWarehouseBackupSummary> listAutonomousDataWarehouseBackupsRecordIterator(final ListAutonomousDataWarehouseBackupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAutonomousDataWarehouseBackupsRequest.Builder>(){

            public ListAutonomousDataWarehouseBackupsRequest.Builder get() {
                return ListAutonomousDataWarehouseBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDataWarehouseBackupsResponse, String>(){

            public String apply(ListAutonomousDataWarehouseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder>, ListAutonomousDataWarehouseBackupsRequest>(){

            public ListAutonomousDataWarehouseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDataWarehouseBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDataWarehouseBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>(){

            public ListAutonomousDataWarehouseBackupsResponse apply(ListAutonomousDataWarehouseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouseBackups(request);
            }
        }, (Function)new Function<ListAutonomousDataWarehouseBackupsResponse, List<AutonomousDataWarehouseBackupSummary>>(){

            public List<AutonomousDataWarehouseBackupSummary> apply(ListAutonomousDataWarehouseBackupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDataWarehousesResponse> listAutonomousDataWarehousesResponseIterator(final ListAutonomousDataWarehousesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAutonomousDataWarehousesRequest.Builder>(){

            public ListAutonomousDataWarehousesRequest.Builder get() {
                return ListAutonomousDataWarehousesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDataWarehousesResponse, String>(){

            public String apply(ListAutonomousDataWarehousesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder>, ListAutonomousDataWarehousesRequest>(){

            public ListAutonomousDataWarehousesRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDataWarehousesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDataWarehousesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>(){

            public ListAutonomousDataWarehousesResponse apply(ListAutonomousDataWarehousesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouses(request);
            }
        });
    }

    public Iterable<AutonomousDataWarehouseSummary> listAutonomousDataWarehousesRecordIterator(final ListAutonomousDataWarehousesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAutonomousDataWarehousesRequest.Builder>(){

            public ListAutonomousDataWarehousesRequest.Builder get() {
                return ListAutonomousDataWarehousesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDataWarehousesResponse, String>(){

            public String apply(ListAutonomousDataWarehousesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder>, ListAutonomousDataWarehousesRequest>(){

            public ListAutonomousDataWarehousesRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDataWarehousesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDataWarehousesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>(){

            public ListAutonomousDataWarehousesResponse apply(ListAutonomousDataWarehousesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouses(request);
            }
        }, (Function)new Function<ListAutonomousDataWarehousesResponse, List<AutonomousDataWarehouseSummary>>(){

            public List<AutonomousDataWarehouseSummary> apply(ListAutonomousDataWarehousesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDatabaseBackupsResponse> listAutonomousDatabaseBackupsResponseIterator(final ListAutonomousDatabaseBackupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAutonomousDatabaseBackupsRequest.Builder>(){

            public ListAutonomousDatabaseBackupsRequest.Builder get() {
                return ListAutonomousDatabaseBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDatabaseBackupsResponse, String>(){

            public String apply(ListAutonomousDatabaseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder>, ListAutonomousDatabaseBackupsRequest>(){

            public ListAutonomousDatabaseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDatabaseBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDatabaseBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>(){

            public ListAutonomousDatabaseBackupsResponse apply(ListAutonomousDatabaseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabaseBackups(request);
            }
        });
    }

    public Iterable<AutonomousDatabaseBackupSummary> listAutonomousDatabaseBackupsRecordIterator(final ListAutonomousDatabaseBackupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAutonomousDatabaseBackupsRequest.Builder>(){

            public ListAutonomousDatabaseBackupsRequest.Builder get() {
                return ListAutonomousDatabaseBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDatabaseBackupsResponse, String>(){

            public String apply(ListAutonomousDatabaseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder>, ListAutonomousDatabaseBackupsRequest>(){

            public ListAutonomousDatabaseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDatabaseBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDatabaseBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>(){

            public ListAutonomousDatabaseBackupsResponse apply(ListAutonomousDatabaseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabaseBackups(request);
            }
        }, (Function)new Function<ListAutonomousDatabaseBackupsResponse, List<AutonomousDatabaseBackupSummary>>(){

            public List<AutonomousDatabaseBackupSummary> apply(ListAutonomousDatabaseBackupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDatabasesResponse> listAutonomousDatabasesResponseIterator(final ListAutonomousDatabasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAutonomousDatabasesRequest.Builder>(){

            public ListAutonomousDatabasesRequest.Builder get() {
                return ListAutonomousDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDatabasesResponse, String>(){

            public String apply(ListAutonomousDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder>, ListAutonomousDatabasesRequest>(){

            public ListAutonomousDatabasesRequest apply(RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDatabasesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>(){

            public ListAutonomousDatabasesResponse apply(ListAutonomousDatabasesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabases(request);
            }
        });
    }

    public Iterable<AutonomousDatabaseSummary> listAutonomousDatabasesRecordIterator(final ListAutonomousDatabasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAutonomousDatabasesRequest.Builder>(){

            public ListAutonomousDatabasesRequest.Builder get() {
                return ListAutonomousDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutonomousDatabasesResponse, String>(){

            public String apply(ListAutonomousDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder>, ListAutonomousDatabasesRequest>(){

            public ListAutonomousDatabasesRequest apply(RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutonomousDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutonomousDatabasesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>(){

            public ListAutonomousDatabasesResponse apply(ListAutonomousDatabasesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabases(request);
            }
        }, (Function)new Function<ListAutonomousDatabasesResponse, List<AutonomousDatabaseSummary>>(){

            public List<AutonomousDatabaseSummary> apply(ListAutonomousDatabasesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBackupsResponse> listBackupsResponseIterator(final ListBackupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBackupsRequest.Builder>(){

            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackupsResponse, String>(){

            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBackupsRequest, ListBackupsResponse>(){

            public ListBackupsResponse apply(ListBackupsRequest request) {
                return DatabasePaginators.this.client.listBackups(request);
            }
        });
    }

    public Iterable<BackupSummary> listBackupsRecordIterator(final ListBackupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBackupsRequest.Builder>(){

            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackupsResponse, String>(){

            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBackupsRequest, ListBackupsResponse>(){

            public ListBackupsResponse apply(ListBackupsRequest request) {
                return DatabasePaginators.this.client.listBackups(request);
            }
        }, (Function)new Function<ListBackupsResponse, List<BackupSummary>>(){

            public List<BackupSummary> apply(ListBackupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDataGuardAssociationsResponse> listDataGuardAssociationsResponseIterator(final ListDataGuardAssociationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataGuardAssociationsRequest.Builder>(){

            public ListDataGuardAssociationsRequest.Builder get() {
                return ListDataGuardAssociationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataGuardAssociationsResponse, String>(){

            public String apply(ListDataGuardAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder>, ListDataGuardAssociationsRequest>(){

            public ListDataGuardAssociationsRequest apply(RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataGuardAssociationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataGuardAssociationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>(){

            public ListDataGuardAssociationsResponse apply(ListDataGuardAssociationsRequest request) {
                return DatabasePaginators.this.client.listDataGuardAssociations(request);
            }
        });
    }

    public Iterable<DataGuardAssociationSummary> listDataGuardAssociationsRecordIterator(final ListDataGuardAssociationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataGuardAssociationsRequest.Builder>(){

            public ListDataGuardAssociationsRequest.Builder get() {
                return ListDataGuardAssociationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataGuardAssociationsResponse, String>(){

            public String apply(ListDataGuardAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder>, ListDataGuardAssociationsRequest>(){

            public ListDataGuardAssociationsRequest apply(RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataGuardAssociationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataGuardAssociationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>(){

            public ListDataGuardAssociationsResponse apply(ListDataGuardAssociationsRequest request) {
                return DatabasePaginators.this.client.listDataGuardAssociations(request);
            }
        }, (Function)new Function<ListDataGuardAssociationsResponse, List<DataGuardAssociationSummary>>(){

            public List<DataGuardAssociationSummary> apply(ListDataGuardAssociationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDatabasesResponse> listDatabasesResponseIterator(final ListDatabasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatabasesRequest.Builder>(){

            public ListDatabasesRequest.Builder get() {
                return ListDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabasesResponse, String>(){

            public String apply(ListDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabasesRequest.Builder>, ListDatabasesRequest>(){

            public ListDatabasesRequest apply(RequestBuilderAndToken<ListDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabasesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDatabasesRequest, ListDatabasesResponse>(){

            public ListDatabasesResponse apply(ListDatabasesRequest request) {
                return DatabasePaginators.this.client.listDatabases(request);
            }
        });
    }

    public Iterable<DatabaseSummary> listDatabasesRecordIterator(final ListDatabasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatabasesRequest.Builder>(){

            public ListDatabasesRequest.Builder get() {
                return ListDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabasesResponse, String>(){

            public String apply(ListDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabasesRequest.Builder>, ListDatabasesRequest>(){

            public ListDatabasesRequest apply(RequestBuilderAndToken<ListDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabasesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDatabasesRequest, ListDatabasesResponse>(){

            public ListDatabasesResponse apply(ListDatabasesRequest request) {
                return DatabasePaginators.this.client.listDatabases(request);
            }
        }, (Function)new Function<ListDatabasesResponse, List<DatabaseSummary>>(){

            public List<DatabaseSummary> apply(ListDatabasesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbHomePatchHistoryEntriesResponse> listDbHomePatchHistoryEntriesResponseIterator(final ListDbHomePatchHistoryEntriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbHomePatchHistoryEntriesRequest.Builder>(){

            public ListDbHomePatchHistoryEntriesRequest.Builder get() {
                return ListDbHomePatchHistoryEntriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbHomePatchHistoryEntriesResponse, String>(){

            public String apply(ListDbHomePatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder>, ListDbHomePatchHistoryEntriesRequest>(){

            public ListDbHomePatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbHomePatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbHomePatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>(){

            public ListDbHomePatchHistoryEntriesResponse apply(ListDbHomePatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatchHistoryEntries(request);
            }
        });
    }

    public Iterable<PatchHistoryEntrySummary> listDbHomePatchHistoryEntriesRecordIterator(final ListDbHomePatchHistoryEntriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbHomePatchHistoryEntriesRequest.Builder>(){

            public ListDbHomePatchHistoryEntriesRequest.Builder get() {
                return ListDbHomePatchHistoryEntriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbHomePatchHistoryEntriesResponse, String>(){

            public String apply(ListDbHomePatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder>, ListDbHomePatchHistoryEntriesRequest>(){

            public ListDbHomePatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbHomePatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbHomePatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>(){

            public ListDbHomePatchHistoryEntriesResponse apply(ListDbHomePatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatchHistoryEntries(request);
            }
        }, (Function)new Function<ListDbHomePatchHistoryEntriesResponse, List<PatchHistoryEntrySummary>>(){

            public List<PatchHistoryEntrySummary> apply(ListDbHomePatchHistoryEntriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbHomePatchesResponse> listDbHomePatchesResponseIterator(final ListDbHomePatchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbHomePatchesRequest.Builder>(){

            public ListDbHomePatchesRequest.Builder get() {
                return ListDbHomePatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbHomePatchesResponse, String>(){

            public String apply(ListDbHomePatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbHomePatchesRequest.Builder>, ListDbHomePatchesRequest>(){

            public ListDbHomePatchesRequest apply(RequestBuilderAndToken<ListDbHomePatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbHomePatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbHomePatchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbHomePatchesRequest, ListDbHomePatchesResponse>(){

            public ListDbHomePatchesResponse apply(ListDbHomePatchesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatches(request);
            }
        });
    }

    public Iterable<PatchSummary> listDbHomePatchesRecordIterator(final ListDbHomePatchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbHomePatchesRequest.Builder>(){

            public ListDbHomePatchesRequest.Builder get() {
                return ListDbHomePatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbHomePatchesResponse, String>(){

            public String apply(ListDbHomePatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbHomePatchesRequest.Builder>, ListDbHomePatchesRequest>(){

            public ListDbHomePatchesRequest apply(RequestBuilderAndToken<ListDbHomePatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbHomePatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbHomePatchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbHomePatchesRequest, ListDbHomePatchesResponse>(){

            public ListDbHomePatchesResponse apply(ListDbHomePatchesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatches(request);
            }
        }, (Function)new Function<ListDbHomePatchesResponse, List<PatchSummary>>(){

            public List<PatchSummary> apply(ListDbHomePatchesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbHomesResponse> listDbHomesResponseIterator(final ListDbHomesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbHomesRequest.Builder>(){

            public ListDbHomesRequest.Builder get() {
                return ListDbHomesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbHomesResponse, String>(){

            public String apply(ListDbHomesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbHomesRequest.Builder>, ListDbHomesRequest>(){

            public ListDbHomesRequest apply(RequestBuilderAndToken<ListDbHomesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbHomesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbHomesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbHomesRequest, ListDbHomesResponse>(){

            public ListDbHomesResponse apply(ListDbHomesRequest request) {
                return DatabasePaginators.this.client.listDbHomes(request);
            }
        });
    }

    public Iterable<DbHomeSummary> listDbHomesRecordIterator(final ListDbHomesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbHomesRequest.Builder>(){

            public ListDbHomesRequest.Builder get() {
                return ListDbHomesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbHomesResponse, String>(){

            public String apply(ListDbHomesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbHomesRequest.Builder>, ListDbHomesRequest>(){

            public ListDbHomesRequest apply(RequestBuilderAndToken<ListDbHomesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbHomesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbHomesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbHomesRequest, ListDbHomesResponse>(){

            public ListDbHomesResponse apply(ListDbHomesRequest request) {
                return DatabasePaginators.this.client.listDbHomes(request);
            }
        }, (Function)new Function<ListDbHomesResponse, List<DbHomeSummary>>(){

            public List<DbHomeSummary> apply(ListDbHomesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbNodesResponse> listDbNodesResponseIterator(final ListDbNodesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbNodesRequest.Builder>(){

            public ListDbNodesRequest.Builder get() {
                return ListDbNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbNodesResponse, String>(){

            public String apply(ListDbNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbNodesRequest.Builder>, ListDbNodesRequest>(){

            public ListDbNodesRequest apply(RequestBuilderAndToken<ListDbNodesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbNodesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbNodesRequest, ListDbNodesResponse>(){

            public ListDbNodesResponse apply(ListDbNodesRequest request) {
                return DatabasePaginators.this.client.listDbNodes(request);
            }
        });
    }

    public Iterable<DbNodeSummary> listDbNodesRecordIterator(final ListDbNodesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbNodesRequest.Builder>(){

            public ListDbNodesRequest.Builder get() {
                return ListDbNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbNodesResponse, String>(){

            public String apply(ListDbNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbNodesRequest.Builder>, ListDbNodesRequest>(){

            public ListDbNodesRequest apply(RequestBuilderAndToken<ListDbNodesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbNodesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbNodesRequest, ListDbNodesResponse>(){

            public ListDbNodesResponse apply(ListDbNodesRequest request) {
                return DatabasePaginators.this.client.listDbNodes(request);
            }
        }, (Function)new Function<ListDbNodesResponse, List<DbNodeSummary>>(){

            public List<DbNodeSummary> apply(ListDbNodesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemPatchHistoryEntriesResponse> listDbSystemPatchHistoryEntriesResponseIterator(final ListDbSystemPatchHistoryEntriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbSystemPatchHistoryEntriesRequest.Builder>(){

            public ListDbSystemPatchHistoryEntriesRequest.Builder get() {
                return ListDbSystemPatchHistoryEntriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemPatchHistoryEntriesResponse, String>(){

            public String apply(ListDbSystemPatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder>, ListDbSystemPatchHistoryEntriesRequest>(){

            public ListDbSystemPatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemPatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemPatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>(){

            public ListDbSystemPatchHistoryEntriesResponse apply(ListDbSystemPatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatchHistoryEntries(request);
            }
        });
    }

    public Iterable<PatchHistoryEntrySummary> listDbSystemPatchHistoryEntriesRecordIterator(final ListDbSystemPatchHistoryEntriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbSystemPatchHistoryEntriesRequest.Builder>(){

            public ListDbSystemPatchHistoryEntriesRequest.Builder get() {
                return ListDbSystemPatchHistoryEntriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemPatchHistoryEntriesResponse, String>(){

            public String apply(ListDbSystemPatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder>, ListDbSystemPatchHistoryEntriesRequest>(){

            public ListDbSystemPatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemPatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemPatchHistoryEntriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>(){

            public ListDbSystemPatchHistoryEntriesResponse apply(ListDbSystemPatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatchHistoryEntries(request);
            }
        }, (Function)new Function<ListDbSystemPatchHistoryEntriesResponse, List<PatchHistoryEntrySummary>>(){

            public List<PatchHistoryEntrySummary> apply(ListDbSystemPatchHistoryEntriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemPatchesResponse> listDbSystemPatchesResponseIterator(final ListDbSystemPatchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbSystemPatchesRequest.Builder>(){

            public ListDbSystemPatchesRequest.Builder get() {
                return ListDbSystemPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemPatchesResponse, String>(){

            public String apply(ListDbSystemPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder>, ListDbSystemPatchesRequest>(){

            public ListDbSystemPatchesRequest apply(RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemPatchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>(){

            public ListDbSystemPatchesResponse apply(ListDbSystemPatchesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatches(request);
            }
        });
    }

    public Iterable<PatchSummary> listDbSystemPatchesRecordIterator(final ListDbSystemPatchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbSystemPatchesRequest.Builder>(){

            public ListDbSystemPatchesRequest.Builder get() {
                return ListDbSystemPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemPatchesResponse, String>(){

            public String apply(ListDbSystemPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder>, ListDbSystemPatchesRequest>(){

            public ListDbSystemPatchesRequest apply(RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemPatchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>(){

            public ListDbSystemPatchesResponse apply(ListDbSystemPatchesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatches(request);
            }
        }, (Function)new Function<ListDbSystemPatchesResponse, List<PatchSummary>>(){

            public List<PatchSummary> apply(ListDbSystemPatchesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemShapesResponse> listDbSystemShapesResponseIterator(final ListDbSystemShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbSystemShapesRequest.Builder>(){

            public ListDbSystemShapesRequest.Builder get() {
                return ListDbSystemShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemShapesResponse, String>(){

            public String apply(ListDbSystemShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemShapesRequest.Builder>, ListDbSystemShapesRequest>(){

            public ListDbSystemShapesRequest apply(RequestBuilderAndToken<ListDbSystemShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemShapesRequest, ListDbSystemShapesResponse>(){

            public ListDbSystemShapesResponse apply(ListDbSystemShapesRequest request) {
                return DatabasePaginators.this.client.listDbSystemShapes(request);
            }
        });
    }

    public Iterable<DbSystemShapeSummary> listDbSystemShapesRecordIterator(final ListDbSystemShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbSystemShapesRequest.Builder>(){

            public ListDbSystemShapesRequest.Builder get() {
                return ListDbSystemShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemShapesResponse, String>(){

            public String apply(ListDbSystemShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemShapesRequest.Builder>, ListDbSystemShapesRequest>(){

            public ListDbSystemShapesRequest apply(RequestBuilderAndToken<ListDbSystemShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemShapesRequest, ListDbSystemShapesResponse>(){

            public ListDbSystemShapesResponse apply(ListDbSystemShapesRequest request) {
                return DatabasePaginators.this.client.listDbSystemShapes(request);
            }
        }, (Function)new Function<ListDbSystemShapesResponse, List<DbSystemShapeSummary>>(){

            public List<DbSystemShapeSummary> apply(ListDbSystemShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemsResponse> listDbSystemsResponseIterator(final ListDbSystemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbSystemsRequest.Builder>(){

            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, String>(){

            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return DatabasePaginators.this.client.listDbSystems(request);
            }
        });
    }

    public Iterable<DbSystemSummary> listDbSystemsRecordIterator(final ListDbSystemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbSystemsRequest.Builder>(){

            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, String>(){

            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return DatabasePaginators.this.client.listDbSystems(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, List<DbSystemSummary>>(){

            public List<DbSystemSummary> apply(ListDbSystemsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbVersionsResponse> listDbVersionsResponseIterator(final ListDbVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbVersionsRequest.Builder>(){

            public ListDbVersionsRequest.Builder get() {
                return ListDbVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbVersionsResponse, String>(){

            public String apply(ListDbVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbVersionsRequest.Builder>, ListDbVersionsRequest>(){

            public ListDbVersionsRequest apply(RequestBuilderAndToken<ListDbVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbVersionsRequest, ListDbVersionsResponse>(){

            public ListDbVersionsResponse apply(ListDbVersionsRequest request) {
                return DatabasePaginators.this.client.listDbVersions(request);
            }
        });
    }

    public Iterable<DbVersionSummary> listDbVersionsRecordIterator(final ListDbVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbVersionsRequest.Builder>(){

            public ListDbVersionsRequest.Builder get() {
                return ListDbVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbVersionsResponse, String>(){

            public String apply(ListDbVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbVersionsRequest.Builder>, ListDbVersionsRequest>(){

            public ListDbVersionsRequest apply(RequestBuilderAndToken<ListDbVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDbVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDbVersionsRequest, ListDbVersionsResponse>(){

            public ListDbVersionsResponse apply(ListDbVersionsRequest request) {
                return DatabasePaginators.this.client.listDbVersions(request);
            }
        }, (Function)new Function<ListDbVersionsResponse, List<DbVersionSummary>>(){

            public List<DbVersionSummary> apply(ListDbVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DatabasePaginators(Database client) {
        this.client = client;
    }
}

