/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.database.Database;
import com.oracle.bmc.database.model.AutonomousDataWarehouse;
import com.oracle.bmc.database.model.AutonomousDataWarehouseBackup;
import com.oracle.bmc.database.model.AutonomousDatabase;
import com.oracle.bmc.database.model.AutonomousDatabaseBackup;
import com.oracle.bmc.database.model.Backup;
import com.oracle.bmc.database.model.DataGuardAssociation;
import com.oracle.bmc.database.model.Database;
import com.oracle.bmc.database.model.DbHome;
import com.oracle.bmc.database.model.DbNode;
import com.oracle.bmc.database.model.DbSystem;
import com.oracle.bmc.database.model.ExadataIormConfig;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GetBackupRequest;
import com.oracle.bmc.database.requests.GetDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GetDatabaseRequest;
import com.oracle.bmc.database.requests.GetDbHomeRequest;
import com.oracle.bmc.database.requests.GetDbNodeRequest;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.requests.GetExadataIormConfigRequest;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.GetBackupResponse;
import com.oracle.bmc.database.responses.GetDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GetDatabaseResponse;
import com.oracle.bmc.database.responses.GetDbHomeResponse;
import com.oracle.bmc.database.responses.GetDbNodeResponse;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.database.responses.GetExadataIormConfigResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DatabaseWaiters {
    private final ExecutorService executorService;
    private final Database client;

    public Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request, AutonomousDataWarehouse.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouse(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request, AutonomousDataWarehouse.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouse(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDataWarehouse.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouse(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(BmcGenericWaiter waiter, GetAutonomousDataWarehouseRequest request, AutonomousDataWarehouse.LifecycleState ... targetStates) {
        final HashSet<AutonomousDataWarehouse.LifecycleState> targetStatesSet = new HashSet<AutonomousDataWarehouse.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse>(){

            public GetAutonomousDataWarehouseResponse apply(GetAutonomousDataWarehouseRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDataWarehouse(request);
            }
        }, (Predicate)new Predicate<GetAutonomousDataWarehouseResponse>(){

            public boolean apply(GetAutonomousDataWarehouseResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDataWarehouse().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDataWarehouse.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request, AutonomousDataWarehouseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouseBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request, AutonomousDataWarehouseBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouseBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDataWarehouseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouseBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(BmcGenericWaiter waiter, GetAutonomousDataWarehouseBackupRequest request, AutonomousDataWarehouseBackup.LifecycleState ... targetStates) {
        final HashSet<AutonomousDataWarehouseBackup.LifecycleState> targetStatesSet = new HashSet<AutonomousDataWarehouseBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse>(){

            public GetAutonomousDataWarehouseBackupResponse apply(GetAutonomousDataWarehouseBackupRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDataWarehouseBackup(request);
            }
        }, (Predicate)new Predicate<GetAutonomousDataWarehouseBackupResponse>(){

            public boolean apply(GetAutonomousDataWarehouseBackupResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDataWarehouseBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDataWarehouseBackup.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(GetAutonomousDatabaseRequest request, AutonomousDatabase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(GetAutonomousDatabaseRequest request, AutonomousDatabase.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(GetAutonomousDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDatabase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(BmcGenericWaiter waiter, GetAutonomousDatabaseRequest request, AutonomousDatabase.LifecycleState ... targetStates) {
        final HashSet<AutonomousDatabase.LifecycleState> targetStatesSet = new HashSet<AutonomousDatabase.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse>(){

            public GetAutonomousDatabaseResponse apply(GetAutonomousDatabaseRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDatabase(request);
            }
        }, (Predicate)new Predicate<GetAutonomousDatabaseResponse>(){

            public boolean apply(GetAutonomousDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDatabase.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request, AutonomousDatabaseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabaseBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request, AutonomousDatabaseBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDatabaseBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDatabaseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabaseBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(BmcGenericWaiter waiter, GetAutonomousDatabaseBackupRequest request, AutonomousDatabaseBackup.LifecycleState ... targetStates) {
        final HashSet<AutonomousDatabaseBackup.LifecycleState> targetStatesSet = new HashSet<AutonomousDatabaseBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse>(){

            public GetAutonomousDatabaseBackupResponse apply(GetAutonomousDatabaseBackupRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDatabaseBackup(request);
            }
        }, (Predicate)new Predicate<GetAutonomousDatabaseBackupResponse>(){

            public boolean apply(GetAutonomousDatabaseBackupResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDatabaseBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDatabaseBackup.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBackupRequest, GetBackupResponse> forBackup(BmcGenericWaiter waiter, GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        final HashSet<Backup.LifecycleState> targetStatesSet = new HashSet<Backup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetBackupRequest, GetBackupResponse>(){

            public GetBackupResponse apply(GetBackupRequest request) {
                return DatabaseWaiters.this.client.getBackup(request);
            }
        }, (Predicate)new Predicate<GetBackupResponse>(){

            public boolean apply(GetBackupResponse response) {
                return targetStatesSet.contains((Object)response.getBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Backup.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(GetDataGuardAssociationRequest request, DataGuardAssociation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataGuardAssociation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(GetDataGuardAssociationRequest request, DataGuardAssociation.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataGuardAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(GetDataGuardAssociationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DataGuardAssociation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataGuardAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(BmcGenericWaiter waiter, GetDataGuardAssociationRequest request, DataGuardAssociation.LifecycleState ... targetStates) {
        final HashSet<DataGuardAssociation.LifecycleState> targetStatesSet = new HashSet<DataGuardAssociation.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse>(){

            public GetDataGuardAssociationResponse apply(GetDataGuardAssociationRequest request) {
                return DatabaseWaiters.this.client.getDataGuardAssociation(request);
            }
        }, (Predicate)new Predicate<GetDataGuardAssociationResponse>(){

            public boolean apply(GetDataGuardAssociationResponse response) {
                return targetStatesSet.contains((Object)response.getDataGuardAssociation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DataGuardAssociation.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(GetDatabaseRequest request, Database.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(GetDatabaseRequest request, Database.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(GetDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Database.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(BmcGenericWaiter waiter, GetDatabaseRequest request, Database.LifecycleState ... targetStates) {
        final HashSet<Database.LifecycleState> targetStatesSet = new HashSet<Database.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDatabaseRequest, GetDatabaseResponse>(){

            public GetDatabaseResponse apply(GetDatabaseRequest request) {
                return DatabaseWaiters.this.client.getDatabase(request);
            }
        }, (Predicate)new Predicate<GetDatabaseResponse>(){

            public boolean apply(GetDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Database.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(GetDbHomeRequest request, DbHome.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbHome(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(GetDbHomeRequest request, DbHome.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbHome(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(GetDbHomeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbHome.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbHome(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(BmcGenericWaiter waiter, GetDbHomeRequest request, DbHome.LifecycleState ... targetStates) {
        final HashSet<DbHome.LifecycleState> targetStatesSet = new HashSet<DbHome.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDbHomeRequest, GetDbHomeResponse>(){

            public GetDbHomeResponse apply(GetDbHomeRequest request) {
                return DatabaseWaiters.this.client.getDbHome(request);
            }
        }, (Predicate)new Predicate<GetDbHomeResponse>(){

            public boolean apply(GetDbHomeResponse response) {
                return targetStatesSet.contains((Object)response.getDbHome().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbHome.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(GetDbNodeRequest request, DbNode.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbNode(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(GetDbNodeRequest request, DbNode.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(GetDbNodeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbNode.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(BmcGenericWaiter waiter, GetDbNodeRequest request, DbNode.LifecycleState ... targetStates) {
        final HashSet<DbNode.LifecycleState> targetStatesSet = new HashSet<DbNode.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDbNodeRequest, GetDbNodeResponse>(){

            public GetDbNodeResponse apply(GetDbNodeRequest request) {
                return DatabaseWaiters.this.client.getDbNode(request);
            }
        }, (Predicate)new Predicate<GetDbNodeResponse>(){

            public boolean apply(GetDbNodeResponse response) {
                return targetStatesSet.contains((Object)response.getDbNode().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbNode.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(BmcGenericWaiter waiter, GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        final HashSet<DbSystem.LifecycleState> targetStatesSet = new HashSet<DbSystem.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDbSystemRequest, GetDbSystemResponse>(){

            public GetDbSystemResponse apply(GetDbSystemRequest request) {
                return DatabaseWaiters.this.client.getDbSystem(request);
            }
        }, (Predicate)new Predicate<GetDbSystemResponse>(){

            public boolean apply(GetDbSystemResponse response) {
                return targetStatesSet.contains((Object)response.getDbSystem().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbSystem.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(GetExadataIormConfigRequest request, ExadataIormConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExadataIormConfig(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(GetExadataIormConfigRequest request, ExadataIormConfig.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExadataIormConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(GetExadataIormConfigRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExadataIormConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExadataIormConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(BmcGenericWaiter waiter, GetExadataIormConfigRequest request, ExadataIormConfig.LifecycleState ... targetStates) {
        final HashSet<ExadataIormConfig.LifecycleState> targetStatesSet = new HashSet<ExadataIormConfig.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetExadataIormConfigRequest, GetExadataIormConfigResponse>(){

            public GetExadataIormConfigResponse apply(GetExadataIormConfigRequest request) {
                return DatabaseWaiters.this.client.getExadataIormConfig(request);
            }
        }, (Predicate)new Predicate<GetExadataIormConfigResponse>(){

            public boolean apply(GetExadataIormConfigResponse response) {
                return targetStatesSet.contains((Object)response.getExadataIormConfig().getLifecycleState());
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DatabaseWaiters(ExecutorService executorService, Database client) {
        this.executorService = executorService;
        this.client = client;
    }
}

