/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousDataWarehouseBackup;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAutonomousDataWarehouseBackupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateAutonomousDataWarehouseBackupConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateAutonomousDataWarehouseBackupRequest interceptRequest(CreateAutonomousDataWarehouseBackupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateAutonomousDataWarehouseBackupRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateAutonomousDataWarehouseBackupDetails(), (String)"createAutonomousDataWarehouseBackupDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousDataWarehouseBackups");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateAutonomousDataWarehouseBackupResponse> fromResponse() {
        Function<Response, CreateAutonomousDataWarehouseBackupResponse> transformer = new Function<Response, CreateAutonomousDataWarehouseBackupResponse>(){

            public CreateAutonomousDataWarehouseBackupResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for CreateAutonomousDataWarehouseBackupResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousDataWarehouseBackup.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateAutonomousDataWarehouseBackupResponse.Builder builder = CreateAutonomousDataWarehouseBackupResponse.builder();
                builder.autonomousDataWarehouseBackup((AutonomousDataWarehouseBackup)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                CreateAutonomousDataWarehouseBackupResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

