/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousDataWarehouse;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAutonomousDataWarehouseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateAutonomousDataWarehouseConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateAutonomousDataWarehouseRequest interceptRequest(CreateAutonomousDataWarehouseRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateAutonomousDataWarehouseRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateAutonomousDataWarehouseDetails(), (String)"createAutonomousDataWarehouseDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousDataWarehouses");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateAutonomousDataWarehouseResponse> fromResponse() {
        Function<Response, CreateAutonomousDataWarehouseResponse> transformer = new Function<Response, CreateAutonomousDataWarehouseResponse>(){

            public CreateAutonomousDataWarehouseResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for CreateAutonomousDataWarehouseResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousDataWarehouse.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateAutonomousDataWarehouseResponse.Builder builder = CreateAutonomousDataWarehouseResponse.builder();
                builder.autonomousDataWarehouse((AutonomousDataWarehouse)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                CreateAutonomousDataWarehouseResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

