/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.requests.DeleteDbHomeRequest;
import com.oracle.bmc.database.responses.DeleteDbHomeResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDbHomeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteDbHomeConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteDbHomeRequest interceptRequest(DeleteDbHomeRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteDbHomeRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDbHomeId(), (String)"dbHomeId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("dbHomes").path(HttpUtils.encodePathSegment((String)request.getDbHomeId()));
        if (request.getPerformFinalBackup() != null) {
            target = target.queryParam("performFinalBackup", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPerformFinalBackup())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, DeleteDbHomeResponse> fromResponse() {
        Function<Response, DeleteDbHomeResponse> transformer = new Function<Response, DeleteDbHomeResponse>(){

            public DeleteDbHomeResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for DeleteDbHomeResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteDbHomeResponse.Builder builder = DeleteDbHomeResponse.builder();
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteDbHomeResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

