/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.Patch;
import com.oracle.bmc.database.requests.GetDbHomePatchRequest;
import com.oracle.bmc.database.responses.GetDbHomePatchResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDbHomePatchConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDbHomePatchConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDbHomePatchRequest interceptRequest(GetDbHomePatchRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDbHomePatchRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDbHomeId(), (String)"dbHomeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPatchId(), (String)"patchId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("dbHomes").path(HttpUtils.encodePathSegment((String)request.getDbHomeId())).path("patches").path(HttpUtils.encodePathSegment((String)request.getPatchId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        return ib;
    }

    public static Function<Response, GetDbHomePatchResponse> fromResponse() {
        Function<Response, GetDbHomePatchResponse> transformer = new Function<Response, GetDbHomePatchResponse>(){

            public GetDbHomePatchResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetDbHomePatchResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Patch.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDbHomePatchResponse.Builder builder = GetDbHomePatchResponse.builder();
                builder.patch((Patch)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDbHomePatchResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

