/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.ExadataIormConfig;
import com.oracle.bmc.database.requests.GetExadataIormConfigRequest;
import com.oracle.bmc.database.responses.GetExadataIormConfigResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetExadataIormConfigConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetExadataIormConfigConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetExadataIormConfigRequest interceptRequest(GetExadataIormConfigRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetExadataIormConfigRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("dbSystems").path(HttpUtils.encodePathSegment((String)request.getDbSystemId())).path("ExadataIormConfig");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetExadataIormConfigResponse> fromResponse() {
        Function<Response, GetExadataIormConfigResponse> transformer = new Function<Response, GetExadataIormConfigResponse>(){

            public GetExadataIormConfigResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetExadataIormConfigResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ExadataIormConfig.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetExadataIormConfigResponse.Builder builder = GetExadataIormConfigResponse.builder();
                builder.exadataIormConfig((ExadataIormConfig)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetExadataIormConfigResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

