/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.ExternalBackupJob;
import com.oracle.bmc.database.requests.GetExternalBackupJobRequest;
import com.oracle.bmc.database.responses.GetExternalBackupJobResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetExternalBackupJobConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetExternalBackupJobConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetExternalBackupJobRequest interceptRequest(GetExternalBackupJobRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetExternalBackupJobRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("externalBackupJobs").path(HttpUtils.encodePathSegment((String)request.getBackupId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        return ib;
    }

    public static Function<Response, GetExternalBackupJobResponse> fromResponse() {
        Function<Response, GetExternalBackupJobResponse> transformer = new Function<Response, GetExternalBackupJobResponse>(){

            public GetExternalBackupJobResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetExternalBackupJobResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ExternalBackupJob.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetExternalBackupJobResponse.Builder builder = GetExternalBackupJobResponse.builder();
                builder.externalBackupJob((ExternalBackupJob)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetExternalBackupJobResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

