/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousDataWarehouseBackupSummary;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehouseBackupsRequest;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehouseBackupsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListAutonomousDataWarehouseBackupsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListAutonomousDataWarehouseBackupsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListAutonomousDataWarehouseBackupsRequest interceptRequest(ListAutonomousDataWarehouseBackupsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListAutonomousDataWarehouseBackupsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousDataWarehouseBackups");
        if (request.getAutonomousDataWarehouseId() != null) {
            target = target.queryParam("autonomousDataWarehouseId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAutonomousDataWarehouseId())});
        }
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        return ib;
    }

    public static Function<Response, ListAutonomousDataWarehouseBackupsResponse> fromResponse() {
        Function<Response, ListAutonomousDataWarehouseBackupsResponse> transformer = new Function<Response, ListAutonomousDataWarehouseBackupsResponse>(){

            public ListAutonomousDataWarehouseBackupsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for ListAutonomousDataWarehouseBackupsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<AutonomousDataWarehouseBackupSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListAutonomousDataWarehouseBackupsResponse.Builder builder = ListAutonomousDataWarehouseBackupsResponse.builder();
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListAutonomousDataWarehouseBackupsResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

