/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.DataGuardAssociation;
import com.oracle.bmc.database.requests.ReinstateDataGuardAssociationRequest;
import com.oracle.bmc.database.responses.ReinstateDataGuardAssociationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReinstateDataGuardAssociationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ReinstateDataGuardAssociationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ReinstateDataGuardAssociationRequest interceptRequest(ReinstateDataGuardAssociationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ReinstateDataGuardAssociationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDatabaseId(), (String)"databaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDataGuardAssociationId(), (String)"dataGuardAssociationId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getReinstateDataGuardAssociationDetails(), (String)"reinstateDataGuardAssociationDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("databases").path(HttpUtils.encodePathSegment((String)request.getDatabaseId())).path("dataGuardAssociations").path(HttpUtils.encodePathSegment((String)request.getDataGuardAssociationId())).path("actions").path("reinstate");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, ReinstateDataGuardAssociationResponse> fromResponse() {
        Function<Response, ReinstateDataGuardAssociationResponse> transformer = new Function<Response, ReinstateDataGuardAssociationResponse>(){

            public ReinstateDataGuardAssociationResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for ReinstateDataGuardAssociationResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DataGuardAssociation.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ReinstateDataGuardAssociationResponse.Builder builder = ReinstateDataGuardAssociationResponse.builder();
                builder.dataGuardAssociation((DataGuardAssociation)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ReinstateDataGuardAssociationResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

