/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseCloneDetails;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="source", defaultImpl=CreateAutonomousDatabaseBase.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CreateAutonomousDatabaseCloneDetails.class, name="DATABASE"), @JsonSubTypes.Type(value=CreateAutonomousDatabaseDetails.class, name="NONE")})
@JsonFilter(value="explicitlySetFilter")
public class CreateAutonomousDatabaseBase {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dbName")
    private final String dbName;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="dataStorageSizeInTBs")
    private final Integer dataStorageSizeInTBs;
    @JsonProperty(value="adminPassword")
    private final String adminPassword;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public Integer getDataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAutonomousDatabaseBase)) {
            return false;
        }
        CreateAutonomousDatabaseBase other = (CreateAutonomousDatabaseBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        Integer this$cpuCoreCount = this.getCpuCoreCount();
        Integer other$cpuCoreCount = other.getCpuCoreCount();
        if (this$cpuCoreCount == null ? other$cpuCoreCount != null : !((Object)this$cpuCoreCount).equals(other$cpuCoreCount)) {
            return false;
        }
        DbWorkload this$dbWorkload = this.getDbWorkload();
        DbWorkload other$dbWorkload = other.getDbWorkload();
        if (this$dbWorkload == null ? other$dbWorkload != null : !((Object)((Object)this$dbWorkload)).equals((Object)other$dbWorkload)) {
            return false;
        }
        Integer this$dataStorageSizeInTBs = this.getDataStorageSizeInTBs();
        Integer other$dataStorageSizeInTBs = other.getDataStorageSizeInTBs();
        if (this$dataStorageSizeInTBs == null ? other$dataStorageSizeInTBs != null : !((Object)this$dataStorageSizeInTBs).equals(other$dataStorageSizeInTBs)) {
            return false;
        }
        String this$adminPassword = this.getAdminPassword();
        String other$adminPassword = other.getAdminPassword();
        if (this$adminPassword == null ? other$adminPassword != null : !this$adminPassword.equals(other$adminPassword)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        LicenseModel this$licenseModel = this.getLicenseModel();
        LicenseModel other$licenseModel = other.getLicenseModel();
        if (this$licenseModel == null ? other$licenseModel != null : !((Object)((Object)this$licenseModel)).equals((Object)other$licenseModel)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        return !(this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateAutonomousDatabaseBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        Integer $cpuCoreCount = this.getCpuCoreCount();
        result = result * 59 + ($cpuCoreCount == null ? 43 : ((Object)$cpuCoreCount).hashCode());
        DbWorkload $dbWorkload = this.getDbWorkload();
        result = result * 59 + ($dbWorkload == null ? 43 : ((Object)((Object)$dbWorkload)).hashCode());
        Integer $dataStorageSizeInTBs = this.getDataStorageSizeInTBs();
        result = result * 59 + ($dataStorageSizeInTBs == null ? 43 : ((Object)$dataStorageSizeInTBs).hashCode());
        String $adminPassword = this.getAdminPassword();
        result = result * 59 + ($adminPassword == null ? 43 : $adminPassword.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        LicenseModel $licenseModel = this.getLicenseModel();
        result = result * 59 + ($licenseModel == null ? 43 : ((Object)((Object)$licenseModel)).hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        return result;
    }

    public String toString() {
        return "CreateAutonomousDatabaseBase(compartmentId=" + this.getCompartmentId() + ", dbName=" + this.getDbName() + ", cpuCoreCount=" + this.getCpuCoreCount() + ", dbWorkload=" + (Object)((Object)this.getDbWorkload()) + ", dataStorageSizeInTBs=" + this.getDataStorageSizeInTBs() + ", adminPassword=" + this.getAdminPassword() + ", displayName=" + this.getDisplayName() + ", licenseModel=" + (Object)((Object)this.getLicenseModel()) + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ")";
    }

    @ConstructorProperties(value={"compartmentId", "dbName", "cpuCoreCount", "dbWorkload", "dataStorageSizeInTBs", "adminPassword", "displayName", "licenseModel", "freeformTags", "definedTags"})
    @Deprecated
    protected CreateAutonomousDatabaseBase(String compartmentId, String dbName, Integer cpuCoreCount, DbWorkload dbWorkload, Integer dataStorageSizeInTBs, String adminPassword, String displayName, LicenseModel licenseModel, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.dbName = dbName;
        this.cpuCoreCount = cpuCoreCount;
        this.dbWorkload = dbWorkload;
        this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        this.adminPassword = adminPassword;
        this.displayName = displayName;
        this.licenseModel = licenseModel;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static enum LicenseModel {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DbWorkload {
        Oltp("OLTP"),
        Dw("DW");

        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid DbWorkload: " + key);
        }

        static {
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

