/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DbIormConfig;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExadataIormConfig {
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="objective")
    private final Objective objective;
    @JsonProperty(value="dbPlans")
    private final List<DbIormConfig> dbPlans;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Objective getObjective() {
        return this.objective;
    }

    public List<DbIormConfig> getDbPlans() {
        return this.dbPlans;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExadataIormConfig)) {
            return false;
        }
        ExadataIormConfig other = (ExadataIormConfig)o;
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$lifecycleDetails = this.getLifecycleDetails();
        String other$lifecycleDetails = other.getLifecycleDetails();
        if (this$lifecycleDetails == null ? other$lifecycleDetails != null : !this$lifecycleDetails.equals(other$lifecycleDetails)) {
            return false;
        }
        Objective this$objective = this.getObjective();
        Objective other$objective = other.getObjective();
        if (this$objective == null ? other$objective != null : !((Object)((Object)this$objective)).equals((Object)other$objective)) {
            return false;
        }
        List<DbIormConfig> this$dbPlans = this.getDbPlans();
        List<DbIormConfig> other$dbPlans = other.getDbPlans();
        if (this$dbPlans == null ? other$dbPlans != null : !((Object)this$dbPlans).equals(other$dbPlans)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $lifecycleDetails = this.getLifecycleDetails();
        result = result * 59 + ($lifecycleDetails == null ? 43 : $lifecycleDetails.hashCode());
        Objective $objective = this.getObjective();
        result = result * 59 + ($objective == null ? 43 : ((Object)((Object)$objective)).hashCode());
        List<DbIormConfig> $dbPlans = this.getDbPlans();
        result = result * 59 + ($dbPlans == null ? 43 : ((Object)$dbPlans).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "ExadataIormConfig(lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", lifecycleDetails=" + this.getLifecycleDetails() + ", objective=" + (Object)((Object)this.getObjective()) + ", dbPlans=" + this.getDbPlans() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"lifecycleState", "lifecycleDetails", "objective", "dbPlans"})
    @Deprecated
    public ExadataIormConfig(LifecycleState lifecycleState, String lifecycleDetails, Objective objective, List<DbIormConfig> dbPlans) {
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.objective = objective;
        this.dbPlans = dbPlans;
    }

    public static enum Objective {
        LowLatency("LOW_LATENCY"),
        HighThroughput("HIGH_THROUGHPUT"),
        Balanced("BALANCED"),
        Auto("AUTO"),
        Basic("BASIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Objective> map;

        private Objective(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Objective create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Objective', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Objective.class);
            map = new HashMap<String, Objective>();
            for (Objective v : Objective.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Bootstrapping("BOOTSTRAPPING"),
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        Updating("UPDATING"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="objective")
        private Objective objective;
        @JsonProperty(value="dbPlans")
        private List<DbIormConfig> dbPlans;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder objective(Objective objective) {
            this.objective = objective;
            this.__explicitlySet__.add("objective");
            return this;
        }

        public Builder dbPlans(List<DbIormConfig> dbPlans) {
            this.dbPlans = dbPlans;
            this.__explicitlySet__.add("dbPlans");
            return this;
        }

        public ExadataIormConfig build() {
            ExadataIormConfig __instance__ = new ExadataIormConfig(this.lifecycleState, this.lifecycleDetails, this.objective, this.dbPlans);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(ExadataIormConfig o) {
            Builder copiedBuilder = this.lifecycleState(o.getLifecycleState()).lifecycleDetails(o.getLifecycleDetails()).objective(o.getObjective()).dbPlans(o.getDbPlans());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

