/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.CreateDataGuardAssociationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateDataGuardAssociationRequest
extends BmcRequest {
    private String databaseId;
    private CreateDataGuardAssociationDetails createDataGuardAssociationDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"databaseId", "createDataGuardAssociationDetails", "opcRetryToken"})
    CreateDataGuardAssociationRequest(String databaseId, CreateDataGuardAssociationDetails createDataGuardAssociationDetails, String opcRetryToken) {
        this.databaseId = databaseId;
        this.createDataGuardAssociationDetails = createDataGuardAssociationDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public CreateDataGuardAssociationDetails getCreateDataGuardAssociationDetails() {
        return this.createDataGuardAssociationDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String databaseId;
        private CreateDataGuardAssociationDetails createDataGuardAssociationDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(CreateDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.createDataGuardAssociationDetails(o.getCreateDataGuardAssociationDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public CreateDataGuardAssociationRequest build() {
            CreateDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder createDataGuardAssociationDetails(CreateDataGuardAssociationDetails createDataGuardAssociationDetails) {
            this.createDataGuardAssociationDetails = createDataGuardAssociationDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateDataGuardAssociationRequest buildWithoutInvocationCallback() {
            return new CreateDataGuardAssociationRequest(this.databaseId, this.createDataGuardAssociationDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateDataGuardAssociationRequest.Builder(databaseId=" + this.databaseId + ", createDataGuardAssociationDetails=" + this.createDataGuardAssociationDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

