/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAutonomousDatabaseRequest
extends BmcRequest {
    private String autonomousDatabaseId;
    private String opcRequestId;

    @ConstructorProperties(value={"autonomousDatabaseId", "opcRequestId"})
    GetAutonomousDatabaseRequest(String autonomousDatabaseId, String opcRequestId) {
        this.autonomousDatabaseId = autonomousDatabaseId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String autonomousDatabaseId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(GetAutonomousDatabaseRequest o) {
            this.autonomousDatabaseId(o.getAutonomousDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public GetAutonomousDatabaseRequest build() {
            GetAutonomousDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAutonomousDatabaseRequest buildWithoutInvocationCallback() {
            return new GetAutonomousDatabaseRequest(this.autonomousDatabaseId, this.opcRequestId);
        }

        public String toString() {
            return "GetAutonomousDatabaseRequest.Builder(autonomousDatabaseId=" + this.autonomousDatabaseId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

