/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDataGuardAssociationRequest
extends BmcRequest {
    private String databaseId;
    private String dataGuardAssociationId;

    @ConstructorProperties(value={"databaseId", "dataGuardAssociationId"})
    GetDataGuardAssociationRequest(String databaseId, String dataGuardAssociationId) {
        this.databaseId = databaseId;
        this.dataGuardAssociationId = dataGuardAssociationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public static class Builder {
        private String databaseId;
        private String dataGuardAssociationId;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(GetDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public GetDataGuardAssociationRequest build() {
            GetDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public GetDataGuardAssociationRequest buildWithoutInvocationCallback() {
            return new GetDataGuardAssociationRequest(this.databaseId, this.dataGuardAssociationId);
        }

        public String toString() {
            return "GetDataGuardAssociationRequest.Builder(databaseId=" + this.databaseId + ", dataGuardAssociationId=" + this.dataGuardAssociationId + ")";
        }
    }
}

