/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbHomePatchHistoryEntryRequest
extends BmcRequest {
    private String dbHomeId;
    private String patchHistoryEntryId;

    @ConstructorProperties(value={"dbHomeId", "patchHistoryEntryId"})
    GetDbHomePatchHistoryEntryRequest(String dbHomeId, String patchHistoryEntryId) {
        this.dbHomeId = dbHomeId;
        this.patchHistoryEntryId = patchHistoryEntryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getPatchHistoryEntryId() {
        return this.patchHistoryEntryId;
    }

    public static class Builder {
        private String dbHomeId;
        private String patchHistoryEntryId;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(GetDbHomePatchHistoryEntryRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.patchHistoryEntryId(o.getPatchHistoryEntryId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public GetDbHomePatchHistoryEntryRequest build() {
            GetDbHomePatchHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder patchHistoryEntryId(String patchHistoryEntryId) {
            this.patchHistoryEntryId = patchHistoryEntryId;
            return this;
        }

        public GetDbHomePatchHistoryEntryRequest buildWithoutInvocationCallback() {
            return new GetDbHomePatchHistoryEntryRequest(this.dbHomeId, this.patchHistoryEntryId);
        }

        public String toString() {
            return "GetDbHomePatchHistoryEntryRequest.Builder(dbHomeId=" + this.dbHomeId + ", patchHistoryEntryId=" + this.patchHistoryEntryId + ")";
        }
    }
}

