/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbSystemPatchHistoryEntryRequest
extends BmcRequest {
    private String dbSystemId;
    private String patchHistoryEntryId;

    @ConstructorProperties(value={"dbSystemId", "patchHistoryEntryId"})
    GetDbSystemPatchHistoryEntryRequest(String dbSystemId, String patchHistoryEntryId) {
        this.dbSystemId = dbSystemId;
        this.patchHistoryEntryId = patchHistoryEntryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getPatchHistoryEntryId() {
        return this.patchHistoryEntryId;
    }

    public static class Builder {
        private String dbSystemId;
        private String patchHistoryEntryId;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(GetDbSystemPatchHistoryEntryRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.patchHistoryEntryId(o.getPatchHistoryEntryId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public GetDbSystemPatchHistoryEntryRequest build() {
            GetDbSystemPatchHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder patchHistoryEntryId(String patchHistoryEntryId) {
            this.patchHistoryEntryId = patchHistoryEntryId;
            return this;
        }

        public GetDbSystemPatchHistoryEntryRequest buildWithoutInvocationCallback() {
            return new GetDbSystemPatchHistoryEntryRequest(this.dbSystemId, this.patchHistoryEntryId);
        }

        public String toString() {
            return "GetDbSystemPatchHistoryEntryRequest.Builder(dbSystemId=" + this.dbSystemId + ", patchHistoryEntryId=" + this.patchHistoryEntryId + ")";
        }
    }
}

