/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetExadataIormConfigRequest
extends BmcRequest {
    private String dbSystemId;
    private String opcRequestId;

    @ConstructorProperties(value={"dbSystemId", "opcRequestId"})
    GetExadataIormConfigRequest(String dbSystemId, String opcRequestId) {
        this.dbSystemId = dbSystemId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String dbSystemId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(GetExadataIormConfigRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public GetExadataIormConfigRequest build() {
            GetExadataIormConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetExadataIormConfigRequest buildWithoutInvocationCallback() {
            return new GetExadataIormConfigRequest(this.dbSystemId, this.opcRequestId);
        }

        public String toString() {
            return "GetExadataIormConfigRequest.Builder(dbSystemId=" + this.dbSystemId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

