/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDataGuardAssociationsRequest
extends BmcRequest {
    private String databaseId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"databaseId", "limit", "page"})
    ListDataGuardAssociationsRequest(String databaseId, Integer limit, String page) {
        this.databaseId = databaseId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String databaseId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(ListDataGuardAssociationsRequest o) {
            this.databaseId(o.getDatabaseId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public ListDataGuardAssociationsRequest build() {
            ListDataGuardAssociationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDataGuardAssociationsRequest buildWithoutInvocationCallback() {
            return new ListDataGuardAssociationsRequest(this.databaseId, this.limit, this.page);
        }

        public String toString() {
            return "ListDataGuardAssociationsRequest.Builder(databaseId=" + this.databaseId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

