/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDbHomePatchesRequest
extends BmcRequest {
    private String dbHomeId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"dbHomeId", "limit", "page"})
    ListDbHomePatchesRequest(String dbHomeId, Integer limit, String page) {
        this.dbHomeId = dbHomeId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String dbHomeId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(ListDbHomePatchesRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public ListDbHomePatchesRequest build() {
            ListDbHomePatchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDbHomePatchesRequest buildWithoutInvocationCallback() {
            return new ListDbHomePatchesRequest(this.dbHomeId, this.limit, this.page);
        }

        public String toString() {
            return "ListDbHomePatchesRequest.Builder(dbHomeId=" + this.dbHomeId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

