/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDbVersionsRequest
extends BmcRequest {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String dbSystemShape;
    private String dbSystemId;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "dbSystemShape", "dbSystemId"})
    ListDbVersionsRequest(String compartmentId, Integer limit, String page, String dbSystemShape, String dbSystemId) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.dbSystemShape = dbSystemShape;
        this.dbSystemId = dbSystemId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDbSystemShape() {
        return this.dbSystemShape;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public static class Builder {
        private String compartmentId;
        private Integer limit;
        private String page;
        private String dbSystemShape;
        private String dbSystemId;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(ListDbVersionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.dbSystemShape(o.getDbSystemShape());
            this.dbSystemId(o.getDbSystemId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public ListDbVersionsRequest build() {
            ListDbVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder dbSystemShape(String dbSystemShape) {
            this.dbSystemShape = dbSystemShape;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public ListDbVersionsRequest buildWithoutInvocationCallback() {
            return new ListDbVersionsRequest(this.compartmentId, this.limit, this.page, this.dbSystemShape, this.dbSystemId);
        }

        public String toString() {
            return "ListDbVersionsRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", dbSystemShape=" + this.dbSystemShape + ", dbSystemId=" + this.dbSystemId + ")";
        }
    }
}

