/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.UpdateDatabaseDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateDatabaseRequest
extends BmcRequest {
    private String databaseId;
    private UpdateDatabaseDetails updateDatabaseDetails;
    private String ifMatch;

    @ConstructorProperties(value={"databaseId", "updateDatabaseDetails", "ifMatch"})
    UpdateDatabaseRequest(String databaseId, UpdateDatabaseDetails updateDatabaseDetails, String ifMatch) {
        this.databaseId = databaseId;
        this.updateDatabaseDetails = updateDatabaseDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public UpdateDatabaseDetails getUpdateDatabaseDetails() {
        return this.updateDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String databaseId;
        private UpdateDatabaseDetails updateDatabaseDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder copy(UpdateDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.updateDatabaseDetails(o.getUpdateDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            return this;
        }

        public UpdateDatabaseRequest build() {
            UpdateDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder updateDatabaseDetails(UpdateDatabaseDetails updateDatabaseDetails) {
            this.updateDatabaseDetails = updateDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateDatabaseRequest buildWithoutInvocationCallback() {
            return new UpdateDatabaseRequest(this.databaseId, this.updateDatabaseDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateDatabaseRequest.Builder(databaseId=" + this.databaseId + ", updateDatabaseDetails=" + this.updateDatabaseDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

