/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.AutonomousDataWarehouse;
import java.beans.ConstructorProperties;

public class CreateAutonomousDataWarehouseResponse {
    private String etag;
    private String opcRequestId;
    private AutonomousDataWarehouse autonomousDataWarehouse;

    @ConstructorProperties(value={"etag", "opcRequestId", "autonomousDataWarehouse"})
    CreateAutonomousDataWarehouseResponse(String etag, String opcRequestId, AutonomousDataWarehouse autonomousDataWarehouse) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.autonomousDataWarehouse = autonomousDataWarehouse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutonomousDataWarehouse getAutonomousDataWarehouse() {
        return this.autonomousDataWarehouse;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private AutonomousDataWarehouse autonomousDataWarehouse;

        public Builder copy(CreateAutonomousDataWarehouseResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.autonomousDataWarehouse(o.getAutonomousDataWarehouse());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder autonomousDataWarehouse(AutonomousDataWarehouse autonomousDataWarehouse) {
            this.autonomousDataWarehouse = autonomousDataWarehouse;
            return this;
        }

        public CreateAutonomousDataWarehouseResponse build() {
            return new CreateAutonomousDataWarehouseResponse(this.etag, this.opcRequestId, this.autonomousDataWarehouse);
        }

        public String toString() {
            return "CreateAutonomousDataWarehouseResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", autonomousDataWarehouse=" + this.autonomousDataWarehouse + ")";
        }
    }
}

