/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.AutonomousDataWarehouse;
import java.beans.ConstructorProperties;

public class GetAutonomousDataWarehouseResponse {
    private String opcRequestId;
    private AutonomousDataWarehouse autonomousDataWarehouse;

    @ConstructorProperties(value={"opcRequestId", "autonomousDataWarehouse"})
    GetAutonomousDataWarehouseResponse(String opcRequestId, AutonomousDataWarehouse autonomousDataWarehouse) {
        this.opcRequestId = opcRequestId;
        this.autonomousDataWarehouse = autonomousDataWarehouse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutonomousDataWarehouse getAutonomousDataWarehouse() {
        return this.autonomousDataWarehouse;
    }

    public static class Builder {
        private String opcRequestId;
        private AutonomousDataWarehouse autonomousDataWarehouse;

        public Builder copy(GetAutonomousDataWarehouseResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.autonomousDataWarehouse(o.getAutonomousDataWarehouse());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder autonomousDataWarehouse(AutonomousDataWarehouse autonomousDataWarehouse) {
            this.autonomousDataWarehouse = autonomousDataWarehouse;
            return this;
        }

        public GetAutonomousDataWarehouseResponse build() {
            return new GetAutonomousDataWarehouseResponse(this.opcRequestId, this.autonomousDataWarehouse);
        }

        public String toString() {
            return "GetAutonomousDataWarehouseResponse.Builder(opcRequestId=" + this.opcRequestId + ", autonomousDataWarehouse=" + this.autonomousDataWarehouse + ")";
        }
    }
}

