/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.Backup;
import java.beans.ConstructorProperties;

public class GetBackupResponse {
    private String etag;
    private String opcRequestId;
    private Backup backup;

    @ConstructorProperties(value={"etag", "opcRequestId", "backup"})
    GetBackupResponse(String etag, String opcRequestId, Backup backup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.backup = backup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Backup getBackup() {
        return this.backup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Backup backup;

        public Builder copy(GetBackupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.backup(o.getBackup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder backup(Backup backup) {
            this.backup = backup;
            return this;
        }

        public GetBackupResponse build() {
            return new GetBackupResponse(this.etag, this.opcRequestId, this.backup);
        }

        public String toString() {
            return "GetBackupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", backup=" + this.backup + ")";
        }
    }
}

