/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.DbSystem;
import java.beans.ConstructorProperties;

public class LaunchDbSystemResponse {
    private String etag;
    private String opcRequestId;
    private DbSystem dbSystem;

    @ConstructorProperties(value={"etag", "opcRequestId", "dbSystem"})
    LaunchDbSystemResponse(String etag, String opcRequestId, DbSystem dbSystem) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.dbSystem = dbSystem;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DbSystem getDbSystem() {
        return this.dbSystem;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private DbSystem dbSystem;

        public Builder copy(LaunchDbSystemResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.dbSystem(o.getDbSystem());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dbSystem(DbSystem dbSystem) {
            this.dbSystem = dbSystem;
            return this;
        }

        public LaunchDbSystemResponse build() {
            return new LaunchDbSystemResponse(this.etag, this.opcRequestId, this.dbSystem);
        }

        public String toString() {
            return "LaunchDbSystemResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", dbSystem=" + this.dbSystem + ")";
        }
    }
}

