/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListAutonomousDatabasesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<AutonomousDatabaseSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListAutonomousDatabasesResponse(String opcRequestId, String opcNextPage, List<AutonomousDatabaseSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<AutonomousDatabaseSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<AutonomousDatabaseSummary> items;

        public Builder copy(ListAutonomousDatabasesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<AutonomousDatabaseSummary> items) {
            this.items = items;
            return this;
        }

        public ListAutonomousDatabasesResponse build() {
            return new ListAutonomousDatabasesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListAutonomousDatabasesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

