/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.DatabaseSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListDatabasesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<DatabaseSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListDatabasesResponse(String opcRequestId, String opcNextPage, List<DatabaseSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<DatabaseSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<DatabaseSummary> items;

        public Builder copy(ListDatabasesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<DatabaseSummary> items) {
            this.items = items;
            return this;
        }

        public ListDatabasesResponse build() {
            return new ListDatabasesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListDatabasesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

