/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.DbNodeSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListDbNodesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<DbNodeSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListDbNodesResponse(String opcRequestId, String opcNextPage, List<DbNodeSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<DbNodeSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<DbNodeSummary> items;

        public Builder copy(ListDbNodesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<DbNodeSummary> items) {
            this.items = items;
            return this;
        }

        public ListDbNodesResponse build() {
            return new ListDbNodesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListDbNodesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

